#include "test_module.h"
#include <glib.h>
#include "appdata.h"
#include "modules/modules.h"
#include <string.h>
#include "event_manager/period.h"
static event* get_event_by_id(const char* id, AppData* data, GError** error)
{
    g_debug("Test module get_event_by_id\n");

    GError* err = NULL;
    
    test_module_data* d = ev_mgr_get_module_data(MOD_ID, data, &err);
    
    if (d->imitate_error) {
        g_set_error(error, MODULE_ERROR, MODULE_ALLOCATE_ERROR, ALLOCATE_ERROR_STRING, 0);
        return NULL;
    }
    event* ev = g_hash_table_lookup(d->events, id); 
    
    return ev_mgr_dup(ev);
}

static void free_event(gpointer ev)
{
    ev_mgr_free((event*) ev, NULL);
}

static int store(event* ev, AppData* data, GError** error)
{
    test_module_data* d = ev_mgr_get_module_data(MOD_ID, data, NULL);
    if (ev->id == NULL) {
        d->id++;
        
        GString* str = g_string_sized_new(4);
        g_string_printf(str, "%d", d->id);
        ev->id = g_string_free(str, FALSE);
    }
    
    g_hash_table_replace(d->events, strdup(ev->id), ev_mgr_dup(ev));
    return 0;
}

static int remove_event(const char* id, AppData* data, GError** error)
{
    test_module_data* d = ev_mgr_get_module_data(MOD_ID, data, NULL);
    
    g_hash_table_remove(d->events, id);
    return 0;
}

static GPtrArray* get_events_by_period(time_t start, time_t end, AppData* data, GError** error)
{
    test_module_data* d = ev_mgr_get_module_data(MOD_ID, data, NULL);
    
    switch (d->st) {
    case 0:
        {;
        event* ev = ev_mgr_new(NULL);
        ev->id = strdup("qwerty");
        ev->service_event_id = strdup(MOD_ID);
        ev->title = strdup("Title ");
        ev->start_time = 1265709600; /* 9.02.2010 10:00:00 */
        ev->end_time = ev->start_time + 3600;

        rule* rul = ev_per_create_rule_from_ical("FREQ=WEEKLY;COUNT=2", 0, 0, 1);
        period* per = ev_per_create_period();

        g_ptr_array_add(per, rul);
        ev->per = per;
    
        GPtrArray* arr = g_ptr_array_new();
        g_ptr_array_add(arr, ev);
        return arr;
        }
    case 1:
        {;
        event* ev = ev_mgr_new(NULL);
        ev->id = strdup("qwerty");
        ev->service_event_id = strdup(MOD_ID);
        ev->title = strdup("Title ");
        ev->start_time = 1265709600;
        ev->end_time = ev->start_time + 3600;

        rule* rul = ev_per_create_rule(0, REC_WEEK, 1);
        rul->count = 4;
        rul->interval = 2;

        GArray* arr = g_array_new(FALSE, FALSE, sizeof(short));
        int a = 4;
        g_array_append_val(arr, a);
        a = 0;
        g_array_append_val(arr, a);
        rul->week_days = arr;
        ev_per_update_rule(rul);

        period* per = ev_per_create_period();
        g_ptr_array_add(per, rul);

        ev->per = per;
        
        GPtrArray* retarr = g_ptr_array_new();
        g_ptr_array_add(retarr, ev);
        return retarr;
        }
    }

}

int test_module_initialize(AppData* data, GError** error)
{
    g_debug("Foo bar test module initialization\n");
    
    test_module_data* tmd = calloc(1, sizeof(test_module_data));
    tmd->a = 5;
    tmd->b = 445;
    tmd->id = 0;
    tmd->imitate_error = 0;
    tmd->st = 0;
    tmd->events = g_hash_table_new_full(g_str_hash, g_str_equal, free, free_event);

    module* mod = (module*) calloc(1, sizeof(module));
    mod->service_name = strdup("Test module calendar service");
    mod->service_string = strdup(MOD_ID);
    mod->data = (void*) tmd;
    mod->service_pixmap = NULL;
    
    mod->get_event_by_id = get_event_by_id;
    mod->store_event = store;
    mod->remove_event = remove_event;
    mod->get_events_by_period = get_events_by_period;

    ev_mgr_register_module(mod, data, NULL);
    return 0;
}
