#include <windows/wcalendar.h>
#include <windows/callbacks.h>
#include <windows/wday.h>
#include <windows/wsettings.h>

#include <windows/wevent.h>

#define BUF 50

void create_calendar(AppData* data)
{
    GtkRcStyle* style;
    
    if(data->calendar == NULL) {
        data->calendar = GTK_WIDGET(gtk_kimi_calendar_new());
    }
    
    /* set style calendar */
    style = gtk_widget_get_modifier_style(GTK_WIDGET(data->calendar));
    style->xthickness = 0;
    style->ythickness = 0;
    gtk_widget_modify_style(GTK_WIDGET(data->calendar), style);
    gtk_kimi_calendar_set_display_options(data->calendar, 10);    

    //gtk_kimi_calendar_set_background (data->calendar, "dp.png");
    //gtk_kimi_calendar_set_rect_day_transparency (data->calendar, 0.8);
}

static GtkWidget* create_menu(AppData* data)
{
    HildonAppMenu *menu;
    
    GtkWidget* bt_prev_month;
    GtkWidget* bt_next_month;
    GtkWidget* bt_goto_today;
    GtkWidget* bt_goto;
    GtkWidget* bt_create_event;
    GtkWidget* bt_settings;
    
    menu = HILDON_APP_MENU(hildon_app_menu_new());

    /* button "previous month" */
    GtkWidget* prev_image;
    bt_prev_month = hildon_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_text(HILDON_BUTTON(bt_prev_month), "Previous month", "");
    prev_image = gtk_image_new_from_stock(GTK_STOCK_GO_BACK, GTK_ICON_SIZE_BUTTON);
    hildon_button_set_image(HILDON_BUTTON(bt_prev_month), prev_image);
    hildon_button_set_image_position(HILDON_BUTTON(bt_prev_month), GTK_POS_LEFT);
    gtk_button_set_alignment(GTK_BUTTON(bt_prev_month), 0.0, 0.5);
    hildon_app_menu_append(menu, GTK_BUTTON(bt_prev_month));

    /* button "next month" */
    GtkWidget* next_image;
    bt_next_month = hildon_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_text(HILDON_BUTTON(bt_next_month), "Next month", "");
    next_image = gtk_image_new_from_stock(GTK_STOCK_GO_FORWARD, GTK_ICON_SIZE_BUTTON);
    hildon_button_set_image(HILDON_BUTTON(bt_next_month), next_image);
    hildon_button_set_image_position(HILDON_BUTTON(bt_next_month), GTK_POS_LEFT);
    gtk_button_set_alignment(GTK_BUTTON(bt_next_month), 0.0, 0.5);
    hildon_app_menu_append(menu, GTK_BUTTON(bt_next_month));

    /* button "go to today" */
    GtkWidget* today_image;
    bt_goto_today = hildon_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_text(HILDON_BUTTON(bt_goto_today), "Go to today", "");
    today_image = gtk_image_new_from_stock(GTK_STOCK_HOME, GTK_ICON_SIZE_BUTTON);
    hildon_button_set_image(HILDON_BUTTON(bt_goto_today), today_image);
    hildon_button_set_image_position(HILDON_BUTTON(bt_goto_today), GTK_POS_LEFT);
    gtk_button_set_alignment(GTK_BUTTON(bt_goto_today), 0.0, 0.5);
    hildon_app_menu_append(menu, GTK_BUTTON(bt_goto_today));

    /* button "go to" */
    GtkWidget* goto_image;
    bt_goto = hildon_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_text(HILDON_BUTTON(bt_goto), "Go to", "");
    goto_image = gtk_image_new_from_stock(GTK_STOCK_JUMP_TO, GTK_ICON_SIZE_BUTTON);
    hildon_button_set_image(HILDON_BUTTON(bt_goto), goto_image);
    hildon_button_set_image_position(HILDON_BUTTON(bt_goto), GTK_POS_LEFT);
    gtk_button_set_alignment(GTK_BUTTON(bt_goto), 0.0, 0.5);
    hildon_app_menu_append(menu, GTK_BUTTON(bt_goto));

    /* button "create new event" */
    GtkWidget* new_image;
    bt_create_event = hildon_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_text(HILDON_BUTTON(bt_create_event), "New event", "");
    new_image = gtk_image_new_from_stock(GTK_STOCK_NEW, GTK_ICON_SIZE_BUTTON);
    hildon_button_set_image (HILDON_BUTTON (bt_create_event), new_image);
    hildon_button_set_image_position (HILDON_BUTTON(bt_create_event), GTK_POS_LEFT);
    gtk_button_set_alignment(GTK_BUTTON(bt_create_event), 0.0, 0.5);
    hildon_app_menu_append(menu, GTK_BUTTON(bt_create_event));

    /* button "settings" */
    GtkWidget* settings_image;
    bt_settings = hildon_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_text(HILDON_BUTTON(bt_settings), "Settings", "");
    settings_image = gtk_image_new_from_stock(GTK_STOCK_PREFERENCES, GTK_ICON_SIZE_BUTTON);
    hildon_button_set_image (HILDON_BUTTON (bt_settings), settings_image);
    hildon_button_set_image_position (HILDON_BUTTON(bt_settings), GTK_POS_LEFT);
    gtk_button_set_alignment(GTK_BUTTON(bt_settings), 0.0, 0.5);
    hildon_app_menu_append(menu, GTK_BUTTON(bt_settings));

    g_signal_connect_after(bt_next_month, "clicked", G_CALLBACK(next_month), data);
    g_signal_connect_after(bt_prev_month, "clicked", G_CALLBACK(previous_month), data);
    g_signal_connect_after(bt_goto_today, "clicked", G_CALLBACK(goto_today), data);
    g_signal_connect_after(bt_goto, "clicked", G_CALLBACK(goto_date), data);
    g_signal_connect_after(bt_create_event, "clicked", G_CALLBACK(create_new_event), data);
    g_signal_connect_after(bt_settings, "clicked", G_CALLBACK(init_wsettings), data);

    gtk_widget_show_all(GTK_WIDGET(menu));

    return GTK_WIDGET(menu);
}

void init_wcalendar(AppData* data)
{
    GtkWidget* win;
    GtkBox* vbox;

    GtkWidget* menu;

    struct tm date;
    char buf_date[BUF];

    int day;
    int month;
    int year;

    win = hildon_stackable_window_new ();
    data->window = (HildonWindow*)win;
    
    vbox = GTK_BOX (gtk_vbox_new (FALSE, 10));
    
    create_calendar(data);
    
    gtk_kimi_calendar_get_date(data->calendar, &year, &month, &day);

    date.tm_sec = 0;             /* seconds */
    date.tm_min = 0;             /* minutes */
    date.tm_hour = 0;            /* hours */
    date.tm_mday = day;          /* day of the month */
    date.tm_mon = month;         /* month */
    date.tm_year = year - 1900;  /* year */

    strftime(buf_date, sizeof buf_date, "%B %Y", &date);
    gtk_window_set_title(GTK_WINDOW(win), buf_date);
	
    gtk_container_add (GTK_CONTAINER (vbox), GTK_WIDGET (data->calendar));
    gtk_container_add (GTK_CONTAINER (win), GTK_WIDGET (vbox));

    g_signal_connect(G_OBJECT(data->calendar), "next-year",
                     G_CALLBACK(date_changed), data);
    g_signal_connect(G_OBJECT(data->calendar), "prev-year",
                     G_CALLBACK(date_changed), data);
    g_signal_connect(G_OBJECT(data->calendar), "next-month",
                     G_CALLBACK(date_changed), data);
    g_signal_connect(G_OBJECT(data->calendar), "prev-month",
                     G_CALLBACK(date_changed), data);
  
    /* Go to window on the day */
    g_signal_connect(G_OBJECT(data->calendar), "day-selected-click",
                     G_CALLBACK(init_wday), data);

    /* create and attach menu to the window */
    menu = create_menu(data);
    hildon_window_set_app_menu(HILDON_WINDOW(win), menu);

    date_changed(NULL, data);
        
    gtk_widget_show_all(win);    
}

