#include <windows/callbacks.h>
#include <windows/wday.h>

#include <time.h>
#include <sys/time.h>

#define BUF 50

/* box question when leaving */
gboolean question_exit(GtkWidget* w, AppData* data)
{
    GtkWidget* note;
    int i;

    GtkWidget* win;
    win = hildon_stackable_window_new();

    /* dialog */
    note = hildon_note_new_confirmation_with_icon_name(GTK_WINDOW(win),
                                                       _("Do you really want to quit?"),
                                                       GTK_STOCK_DIALOG_QUESTION);

    i = gtk_dialog_run(GTK_DIALOG(note));

    if (i != GTK_RESPONSE_OK) {
	gtk_widget_destroy(GTK_WIDGET(note));
    gtk_widget_destroy(GTK_WIDGET(win));
        return TRUE;
    }

    gtk_widget_destroy(GTK_WIDGET(note));
    gtk_widget_destroy(GTK_WIDGET(win));
    gtk_main_quit();
    return FALSE;
}

void date_changed(GtkWidget* w, AppData* data)
{
    guint year;
    guint month;
    guint day;
    time_t start;
    time_t end;
    struct tm date;
    char buf_date[BUF];
  
    gtk_kimi_calendar_get_date(data->calendar,
		                       &year,
			                   &month,
			                   &day);
    
    date.tm_sec = 0;             /* seconds */
    date.tm_min = 0;             /* minutes */
    date.tm_hour = 0;            /* hours */
    date.tm_mday = day;          /* day of the month */
    date.tm_mon = month;         /* month */
    date.tm_year = year - 1900;  /* year */
    
    /* set new date */
    strftime(buf_date, sizeof buf_date, "%B %Y", &date);
    gtk_window_set_title(GTK_WINDOW(data->window), buf_date);

    /* diapason - start month and end month */
    date.tm_sec = 0;             /* seconds */
    date.tm_min = 0;             /* minutes */
    date.tm_hour = 0;            /* hours */
    date.tm_mday = 1;            /* day of the month */
    date.tm_mon = month;         /* month */
    date.tm_year = year - 1900;  /* year */

    start = mktime(&date);

    date.tm_sec -= 1;
    date.tm_min = 0;
    date.tm_hour = 0;
    date.tm_mday = 1;
    date.tm_mon = month + 1;
    date.tm_year = year - 1900;

    end = mktime(&date);

    //hildon_gtk_window_set_progress_indicator (data->window, 1);					
    kimi_get_by_period(start, end, data->kimi, NULL);		
    //hildon_gtk_window_set_progress_indicator (data->window, 0);

    update_marks(data);
}

void update_marks(AppData* data)
{
    GArray* del = data->kimi->date_event_list;
    int i;
    struct tm *date_mark;

    /* delete all marks */
    gtk_kimi_calendar_clear_marks(data->calendar);

    for (i = 0; i < del->len; i++) {
        DateEventList dl = g_array_index(del, DateEventList, i);
        GPtrArray* evs = dl.events;
        if(evs->len > 0) {
	        date_mark = localtime(&dl.date);
	        gtk_kimi_calendar_mark_day(data->calendar, date_mark->tm_mday);
        }
    }
}

void changed_event_type(GtkWidget* w, AppData* data)
{
    int id_type;

    /* type */
    id_type = hildon_picker_button_get_active(data->button_type);

    if (id_type == 1) {
        /* off end date and time */
        gtk_widget_set_sensitive(GTK_WIDGET(data->button_end_date), FALSE);
     	gtk_widget_set_sensitive(GTK_WIDGET(data->button_end_time), FALSE);
    } else {
     	/* on end date and time */
        gtk_widget_set_sensitive(GTK_WIDGET(data->button_end_date), TRUE);
     	gtk_widget_set_sensitive(GTK_WIDGET(data->button_end_time), TRUE);
    }
}

void save_event(GtkWidget* w, AppData* data)
{
    HildonWindowStack* wstack;
    Event *save_ev;
    const char* service_id;
    const char* id;
    const char* title;
    int id_type; 
    const char* location;
    time_t start;
    time_t end;
    time_t remind;
    struct tm tmp_date;
    GtkWidget *banner;
    GPtrArray* modules;
    Module* module;
    int num_storage;

    id = NULL;

    save_ev = kimi_event_new(NULL);

    /* title, location */
    title = hildon_entry_get_text(data->entry_name);
    location = hildon_entry_get_text(data->entry_location);

    /* type */
    id_type = hildon_picker_button_get_active(data->button_type);

    /* date start */
    hildon_date_button_get_date(data->button_start_date, &tmp_date.tm_year, &tmp_date.tm_mon, &tmp_date.tm_mday);
    hildon_time_button_get_time(data->button_start_time, &tmp_date.tm_hour, &tmp_date.tm_min);
    tmp_date.tm_sec = 0;
    tmp_date.tm_isdst = -1;   
    tmp_date.tm_year -= 1900; 
    start = mktime(&tmp_date);

    /* date end */
    if (save_ev->id_type == 0) {
        hildon_date_button_get_date(data->button_end_date, &tmp_date.tm_year, &tmp_date.tm_mon, &tmp_date.tm_mday);
     	hildon_time_button_get_time(data->button_end_time, &tmp_date.tm_hour, &tmp_date.tm_min);
        tmp_date.tm_sec = 0;
    	tmp_date.tm_isdst = -1;
    	tmp_date.tm_year -= 1900;

        end = mktime(&tmp_date);
        
        if(start > end){
            if(id_type == 0){
                banner = hildon_banner_show_information(data->window,
                                                        GTK_STOCK_DIALOG_WARNING,
				                                        _("Kimi: Start date more than end date"));
                return;
            }
        }
    }

    /* remind */
    if(data->num_remind == 0) {
        remind = -1; /* unset */
    } else {
        if(data->num_remind == 1) {
            remind = 0; /* 0 min */
        } else {
            if(data->num_remind == 2) {
                remind = 60*5; /* 5 min */
            } else {
                if(data->num_remind == 3) {
                    remind = 60*10; /* 10 min */
                } else {
                    if(data->num_remind == 4) {
                        remind = 60*15; /* 15 min */
                    }
                }
            }
        }
    }

    /* save */
    modules = kimi_get_modules(data->kimi);
    num_storage = hildon_picker_button_get_active(data->button_storage);

    if(num_storage == -1) {
        banner = hildon_banner_show_information(data->window,
                                                GTK_STOCK_DIALOG_WARNING,
                                                _("Kimi: Storage not selected"));
        return;
    }

    module = g_ptr_array_index(modules, num_storage);

    if(data->edit_ev != NULL) {
        if(strcmp(data->edit_ev->service_event_id, module->service_string) == 0) {  
            id = data->edit_ev->id; 
        } else {
            id = NULL;
        } 
    } 

    kimi_event_fill(save_ev,
         module->service_string,
         id, 
         title,
         data->desc,
         location,
         start,
         end,
         NULL,
         NULL);

    save_ev->id_type = id_type;
    save_ev->remind = remind;

    if(kimi_store(save_ev, data->kimi, NULL)) {
        banner = hildon_banner_show_information(data->window,
		                                GTK_STOCK_DIALOG_ERROR,
		                                _("Kimi: Error saving event"));
    }

    update_marks(data);
    update_day_view(data);

    /* clear */
    kimi_event_free(save_ev, NULL);

    wstack = hildon_window_stack_get_default();
    hildon_window_stack_pop_1(wstack);
}

void save_event_more(GtkWidget* w, AppData* data)
{
    HildonWindowStack* wstack;
    GtkTextIter start;
    GtkTextIter end;
    GtkTextBuffer* buffer;
    char* desc;
    /* save event more */
    buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(data->text_view));

    gtk_text_buffer_get_start_iter(buffer, &start);
    gtk_text_buffer_get_end_iter(buffer, &end);

    /* copy description in data->desc */
    desc = gtk_text_buffer_get_text(buffer, &start, &end, FALSE);
    if(data->desc != NULL){
        g_free(data->desc);
        data->desc = NULL;
    }
    data->desc = strdup(desc);
    data->num_remind = hildon_picker_button_get_active(data->button_remind);
    data->num_repeat = hildon_picker_button_get_active(data->button_repeat);

    wstack = hildon_window_stack_get_default();
    hildon_window_stack_pop_1(wstack);
}

/* get id selected event in treeview */
guint get_id_selected_row(GtkTreeView* treeview)
{
    GtkTreeIter iter;
    GtkTreeModel* model;
    GtkTreeSelection* selection;
    guint i;
    GValue val = {0,};

    model = gtk_tree_view_get_model(GTK_TREE_VIEW(treeview));
    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));

    /* get iter selected string */
    if (gtk_tree_selection_get_selected(selection, NULL, &iter)) {
	    /* get value of the third column(Type G_TYPE_INT) in the selected row */
	    gtk_tree_model_get_value(model, &iter, 4 , &val);
	    /* get number of the selected row in the source list(array) for the selected row */
	    i = g_value_get_int(&val);
        
        g_value_unset(&val);

	    return i;
    }

    return (guint)-1;
}

void delete_selected_event(GtkWidget* w, AppData* data)
{
    guint num;
    Event *ev;
    int day;
    int month;
    int year;
    struct tm date;
    int resp;
    GtkWidget* banner;
    GtkWidget* dialog;

    num = get_id_selected_row(GTK_TREE_VIEW(data->day_treeview));
    if(num == -1) {
        return;
    }

    gtk_kimi_calendar_get_date(data->calendar,
		                       &year,
			                   &month,
			                   &day);

    /* find event */
    GArray* del = data->kimi->date_event_list;
    int i;
    for (i = 0; i < del->len; i++) {
        DateEventList dl = g_array_index(del, DateEventList, i);

        date = *localtime(&dl.date);

        if (day == date.tm_mday) {
            GPtrArray* evs = dl.events;
            ev = g_ptr_array_index(evs, num);
            break;
        }
    }

    /* delete? */
    dialog = hildon_note_new_confirmation_with_icon_name(GTK_WINDOW(data->window),
                                                       _("Delete the selected event?"),
                                                       GTK_STOCK_DIALOG_QUESTION);
    resp = gtk_dialog_run(GTK_DIALOG(dialog));

    if (resp != GTK_RESPONSE_OK) {
	    gtk_widget_destroy(GTK_WIDGET(dialog));
        return;
    }

    gtk_widget_destroy(GTK_WIDGET(dialog));

    resp = kimi_event_remove(ev->id, ev->service_event_id, data->kimi, NULL);
    if (resp) {
	    banner = hildon_banner_show_information(data->window,
				                                GTK_STOCK_DIALOG_ERROR,
				                                _("Kimi: Error removing event"));
	}

    update_marks(data);
    update_day_view(data);
}

void edit_selected_event(GtkWidget* w, AppData* data)
{
    guint num;
    int day;
    int year;
    int month;
    Event *ev;
    struct tm date;
    struct tm start_time;
    struct tm end_time;
    GtkWidget* top_win;
    HildonWindowStack* wstack;
    
    gtk_kimi_calendar_get_date(data->calendar,
		                       &year,
			                   &month,
			                   &day);

    num = get_id_selected_row(GTK_TREE_VIEW(data->day_treeview));
    if(num == -1) {
        return;
    }

    /* create window - edit event */
    init_wevent(NULL, data);

    /* find event */
    GArray* del = data->kimi->date_event_list;
    int i;
    for (i = 0; i < del->len; i++) {
        DateEventList dl = g_array_index(del, DateEventList, i);

        date = *localtime(&dl.date);

        if (day == date.tm_mday) {
            GPtrArray* evs = dl.events;
            ev = g_ptr_array_index(evs, num);
            break;
        }
    }

    data->edit_ev = ev;

    /* set title window */
    wstack = hildon_window_stack_get_default();
    top_win = hildon_window_stack_peek(wstack); 
    gtk_window_set_title(GTK_WINDOW(top_win), ev->title);  
 
    /* filling forms */
    hildon_entry_set_text(data->entry_name, ev->title);
    hildon_entry_set_text(data->entry_location, ev->location);
    
    /* set type */
    hildon_picker_button_set_active(data->button_type, ev->id_type);
    changed_event_type(NULL, data);

    /* set start date */
    start_time = *localtime(&ev->start_time);
    hildon_date_button_set_date(data->button_start_date, start_time.tm_year + 1900, start_time.tm_mon, start_time.tm_mday);
    hildon_time_button_set_time(data->button_start_time, start_time.tm_hour, start_time.tm_min);

    /* set end date */
    end_time = *localtime(&ev->end_time); 
    hildon_date_button_set_date(data->button_end_date, end_time.tm_year + 1900, end_time.tm_mon, end_time.tm_mday);
    hildon_time_button_set_time(data->button_end_time, end_time.tm_hour, end_time.tm_min);

    /* set storage */
    GPtrArray* modules = kimi_get_modules(data->kimi);
    Module* module;
    for (i = 0; i < modules->len; i++) {
        module = g_ptr_array_index(modules, i);
        if(strcmp(module->service_string, ev->service_event_id) == 0){
	    break;
	}
    }						
        
    hildon_picker_button_set_active(data->button_storage, i);

    if(data->desc != NULL){
        g_free(data->desc);
        data->desc = NULL;
    }
    data->desc = strdup(ev->description);
    
    /* set repeat */
    data->num_repeat = 0;

    /* set remind */
    if(ev->remind == -1) {
        data->num_remind = 0; /* unset */
    } else {
        if(ev->remind == 0) {
            data->num_remind = 1; /* 0 min */
        } else {
            if(ev->remind > 0 && ev->remind <= 60*5) {
                data->num_remind = 2; /* 5 min */
            } else {
                if(ev->remind > 60*5 && ev->remind <= 60*10) {
                    data->num_remind = 3; /* 10 min */
                } else {
                    if(ev->remind > 60*10) {
                        data->num_remind = 4; /* 15 min */
                    }
                }
            }
        }
    }
}

void create_new_event(GtkWidget* w, AppData* data)
{
    /* clear */
    if(data->desc != NULL){
        g_free(data->desc);
        data->desc = NULL;
    }
    data->desc = strdup("");
    
    data->num_remind = 0;
    data->num_repeat = 0;
    
    data->edit_ev = NULL;

    init_wevent(NULL, data);
} 

void next_month(GtkWidget* w, AppData* data)
{
    int max_day;
    int day;
    int month;
    int year;

    gtk_kimi_calendar_get_date(data->calendar,
	         	               &year,
			                   &month,
			                   &day);

    if(month < 11) {
       month++;
    } else {
       month = 0;
       year++;
    }

    max_day = g_date_get_days_in_month(month+1, year);
    if(day > max_day) {
    day = max_day;
    }

    /* calendar set new date */
    gtk_kimi_calendar_select_day(data->calendar,
                                 day);
    gtk_kimi_calendar_select_month(data->calendar,
                                   month,
                                   year);

    date_changed(NULL, data);
}

void previous_month(GtkWidget* w, AppData* data)
{
    int max_day;
    int day;
    int month;
    int year;

    gtk_kimi_calendar_get_date(data->calendar,
	         	               &year,
			                   &month,
			                   &day);

    if(month > 0) {
       month--;
    } else {
       month = 11;
       year--;
    }

    /* calendar set new date */
    gtk_kimi_calendar_select_month(data->calendar,
                              month,
                              year);
    
    max_day = g_date_get_days_in_month(month+1, year);
    if(day > max_day) {
    day = max_day;
    }

    gtk_kimi_calendar_select_day(data->calendar,
                            day);

    date_changed(NULL, data);
}

void goto_today(GtkWidget* w, AppData* data)
{
    struct timeval t;
    struct tm* date;
    int day;
    int month;
    int year;

    gtk_kimi_calendar_get_date(data->calendar,
	         	               &year,
			                   &month,
			                   &day);

    /* get date - today */
	gettimeofday(&t, NULL);
	date = localtime((time_t *) (&(t.tv_sec)));

    /* calendar set new date */
    gtk_kimi_calendar_select_month(data->calendar,
                                   date->tm_mon,
				                   date->tm_year + 1900);
    gtk_kimi_calendar_select_day(data->calendar,
                            date->tm_mday);
    
    if(year != date->tm_year + 1900 || month != date->tm_mon) {
        date_changed(NULL, data);
    }
}

void goto_date(GtkWidget* w, AppData* data)
{
    GtkWidget* dialog;
    GtkWidget* date_selector;
    int result;
    int day;
    int month;
    int year;
    int old_month;
    int old_year;

    date_selector = hildon_date_selector_new();
    gtk_kimi_calendar_get_date(data->calendar, &year, &month, &day);
    old_month = month;
    old_year = year;
    hildon_date_selector_select_current_date(date_selector, year, month, day);

    dialog = hildon_picker_dialog_new(GTK_WIDGET(data->window));
    hildon_picker_dialog_set_selector(dialog, (HildonTouchSelector *)date_selector);
    hildon_picker_dialog_set_done_label(dialog, _("Done"));
    
    result = gtk_dialog_run(GTK_DIALOG(dialog));

    hildon_date_selector_get_date(date_selector,
		                  &year,
		                  &month,
		                  &day);

    /* calendar set new date */
    gtk_kimi_calendar_select_day(data->calendar,
                                 1);
    gtk_kimi_calendar_select_month(data->calendar,
                                   month,
				                   year);
    gtk_kimi_calendar_select_day(data->calendar,
                                 day);

    gtk_widget_destroy(GTK_WIDGET(date_selector));
    gtk_widget_destroy(GTK_WIDGET(dialog)); 

    if(old_year != year || old_month != month) {
        date_changed(NULL, data);
    }
}

void previous_day(GtkWidget* w, AppData* data)
{
    int day;
    int month;
    int year;
    HildonWindowStack* wstack;

    gtk_kimi_calendar_get_date(data->calendar,
	         	               &year,
			                   &month,
			                   &day);

    if(day > 1) {
       day--;
    } else {
       previous_month(NULL, data);
       gtk_kimi_calendar_get_date(data->calendar,
	            	              &year,
		   	                      &month,
			                      &day);
       day = g_date_get_days_in_month(month+1, year);
    }

    gtk_kimi_calendar_select_day(data->calendar,
                                 day);

    /* delete top window */
    wstack = hildon_window_stack_get_default();
    hildon_window_stack_pop_1(wstack);

    init_wday(NULL, data);
}

void next_day(GtkWidget* w, AppData* data)
{
    int max_day;
    int day;
    int month;
    int year;
    HildonWindowStack* wstack;

    gtk_kimi_calendar_get_date(data->calendar,
	         	               &year,
			                   &month,
			                   &day);

    max_day = g_date_get_days_in_month(month+1, year);

    if(day < max_day) {
       day++;
    } else {
       next_month(NULL, data);
       day = 1;
    }

    gtk_kimi_calendar_select_day(data->calendar,
                                 day);

    /* delete top window */
    wstack = hildon_window_stack_get_default();
    hildon_window_stack_pop_1(wstack);

    init_wday(NULL, data);
}

void goto_today_day(GtkWidget* w, AppData* data)
{
    HildonWindowStack* wstack;

    goto_today(NULL, data);

    /* delete top window */
    wstack = hildon_window_stack_get_default();
    hildon_window_stack_pop_1(wstack);

    init_wday(NULL, data);
}

void goto_day(GtkWidget* w, AppData* data)
{
    HildonWindowStack* wstack;

    goto_date(NULL, data);

    /* delete top window */
    wstack = hildon_window_stack_get_default();
    hildon_window_stack_pop_1(wstack);

    init_wday(NULL, data);
}

GdkPixbuf* b64_to_pixbuf(guchar* undecoded)
{
    GdkPixbuf* pixbuf = NULL;
    GdkPixbufLoader* loader;
    guchar* buff = NULL;
    int size;
    
    if(undecoded == NULL) {
        return NULL;
    }

    buff = g_base64_decode(undecoded, &size);
    loader = gdk_pixbuf_loader_new();
    gdk_pixbuf_loader_write(loader, buff, size, NULL);
    pixbuf = gdk_pixbuf_loader_get_pixbuf(loader);

    if(pixbuf != NULL){
        g_object_ref(pixbuf);
    }
    
    gdk_pixbuf_loader_close(loader, NULL);
    
    g_object_unref((gpointer) loader);

    if(buff != NULL){
        g_free(buff);
    }   
    return pixbuf; 	
}

void show_banner(gchar* title, gchar* message)
{
    GtkWidget *banner;
    gchar* str = NULL;

    if(message == NULL && title == NULL) {
        return;
    }

    if(message == NULL) {
        str = g_strconcat("Kimi: ", title, NULL);
    }

    if(title == NULL) {
        str = g_strconcat("Kimi: ", message, NULL);
    }

    if(title != NULL && message != NULL) {
        str = g_strconcat("Kimi: ", title, "\n", message, NULL);
    }

    banner = hildon_banner_show_information(NULL, NULL, str);
    hildon_banner_set_timeout(HILDON_BANNER(banner), 5000);

    if(str != NULL) {
        g_free(str);
    }

    return;
}

