#ifndef KIMICONSOLE_H
#define KIMICONSOLE_H
#include <kimi.h>
#include <stdio.h>
typedef struct _KimiConsole KimiConsole;
typedef enum _KimiConsoleState KimiConsoleState;
typedef enum _OutputMode OutputMode;

enum _KimiConsoleState
{
    NOT_INITIALIZED = 0,
    INITIALIZED
};

enum _OutputMode 
{
    OM_NORMAL = 0,
    OM_TEST
};

struct _KimiConsole
{
    int stop;
    Kimi* kimi;
    GPtrArray* module_paths;
    KimiConsoleState state;
    
    int isInteractive;
    char* file;
    FILE* handle;
    
    char* outfile;
    FILE* out;

    OutputMode output_mode;
};

/**
 * This function changes current script file, and changes mode to non-interactive
 * @param kc KimiConsole context
 * @param file filename
 * @return 0 if success, -1 if error
 */
int open_and_execute_script(KimiConsole*, const char*);

#endif
