/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
#define CTF_LOG_FORMAT_USE_TIME
#define CTF_THROW_EXIT

#include "../CTF/src/ctf.h"
#include <ui/callbacks.h>
#include <settings/settings.h>
#include <appdata.h>
#include <time.h>

GLOBAL_DECL();
CTF_TEST_DATA_FILE_NAME_DECL;
CTF_STAT_FILE_NAME_DECL;

CTF_TEST_CASE(date_changed_test) {
    CTF_TEST_NAME("date_changed_test");
    AppData   *data;
    struct tm *date;
    int       i;
    data = create_data();
    conf_init(data);
    
    date_changed(NULL, data);
    g_debug("OK\n");
    
    date_id_list *id_list = data->id_list;
    for(i = 0; id_list[i].date > 0; ++i) {
	date = localtime(&(id_list[i].date));
        CTF_CHECK(date->tm_mon  == atoi(CTF_TEST_DATA("KIMI_TEST_DATE_CHANGED_MONTH")));
        CTF_CHECK(date->tm_year + 1900 == atoi(CTF_TEST_DATA("KIMI_TEST_DATE_CHANGED_YEAR")));
    }
}
