/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */

#ifndef CALLBACKS_H
#define CALLBACKS_H

#include <settings/settings.h>
#include <events/events.h>
#include <time.h>
#include <sys/time.h>

#ifndef PIXMAP_PATH
#define PIXMAP_PATH "data/pixmaps"
#endif

#define CHECK_PIXMAP PIXMAP_PATH"/40x40/check.png"
#define UNCHECK_PIXMAP PIXMAP_PATH"/40x40/uncheck.png"

#ifndef SOUND_PATH
#define SOUND_PATH "data/sounds"
#endif

#define SOUND_WOOD SOUND_PATH"/1.wav"

enum {
    UNSET,
    MINUTE,
    HOUR,
    DAY
};

gboolean question_exit(GtkWidget* w, AppData* data);
void date_changed(GtkWidget* w, AppData* data);

void show_calendar(GtkWidget* w, AppData* data);
void show_day(GtkWidget* w, AppData* data);
void show_event_new(GtkWidget* w, AppData* data);
void show_event_edit(GtkWidget* w, AppData* data);
void show_import_events(GtkWidget* w, AppData* data);
void show_settings(GtkWidget* w, AppData* data);

void search(GtkWidget* w, AppData* data);

void show_window_previous(GtkWidget* w, AppData* data);

void save_event(GtkWidget* w, AppData* data);
void save_import_events(GtkWidget* w, AppData* data);
void remove_event(GtkWidget* w, AppData* data);

void save_settings(GtkWidget* w, AppData* data);
void window_fullscreen(GtkWidget* w, AppData* data);
static void toolbar_add_bt(const char* widget_name, AppData* data);

static void next_event(GtkWidget* w, AppData* data);
static void back_event(GtkWidget* w, AppData* data);
static void next_day(GtkWidget* w, AppData* data);

void ev_changed_type(GtkWidget* w, AppData* data);
void event_edit_set_reminder(GtkWidget* w, AppData* data);
static void event_upload(GtkWidget* w, AppData* data);

static guint get_n_str(GtkTreeView* tree_view);

static void fixed_toggled (GtkCellRendererToggle* cell, gchar* path_str, gpointer data);
static void ev_import_check_all(GtkWidget* w, gpointer user_data);

static GtkTreeModel* create_and_fill_model(int day, AppData* data);
static GtkTreeModel* new_model_import_events(AppData* data);
static GtkTreeModel* new_model_search_events(const char* filter, AppData* data, date_id_list* id_list);

static GtkWidget* new_view_import_events(GtkTreeModel* model);
static GtkWidget* create_view();

int connection(GtkWidget* w, AppData* data);
static void connection_handler(ConIcConnection* connection, ConIcConnectionEvent* event, gpointer user_data);

gboolean key_press_cb(GtkWidget* widget, GdkEventKey* event, AppData* data);

int set_login(GtkWidget* w, AppData* data);

void not_realised_feature(GtkWidget* w, AppData* data);

void select_date_dialog(GtkWidget* w, AppData* data);

void callback_help(GtkWidget* w, AppData* data);
#endif
