/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
#include <stdio.h>
#include <sqlite3.h>
#include "appdata.h"
#include <events/events.h>

#include <libosso.h>

#define SYSNOTE_NAME  "org.freedesktop.Notifications"
#define SYSNOTE_OPATH "/org/freedesktop/Notifications"
#define SYSNOTE_IFACE "org.freedesktop.Notifications"
#define SYSNOTE_NOTE  "SystemNoteDialog"
char* home_path = NULL;
char* build_full_path(const char* filename)
{
    char* result = NULL;
    char* home_var = home_path;
    int len = strlen(home_var) + 1 + \
            strlen(filename);

    result = malloc(len + 1);
    snprintf(result, len + 1, "%s%s", home_var, filename);

    return result;
}

static void show_message(event* ev) {
    int i = 0;
    osso_context_t* ossoContext = NULL;
    ossoContext = osso_initialize("ru.karelia.cs.kimialarm", "1.0", FALSE, NULL);
    if (ossoContext == NULL) {
        return; 
    }
    char buf[1024];
    sprintf(buf, "Kimi alarm:\n %s", ev->title);
    osso_rpc_t methodResult = {};
    osso_rpc_run(ossoContext,
                          SYSNOTE_NAME,      /* well-known name */
                          SYSNOTE_OPATH,         /* object path */
                          SYSNOTE_IFACE,           /* interface */
                          SYSNOTE_NOTE,          /* method name */
                          &methodResult, /* method return value */

                          DBUS_TYPE_STRING, buf,
                          DBUS_TYPE_UINT32, 2,
                          DBUS_TYPE_STRING, "Ok",
                          DBUS_TYPE_INVALID);
    osso_deinitialize(ossoContext);
    return;
}

int main(int argv, char** argc)
{
    home_path = argc[2];
    
    AppData* data = malloc(sizeof(AppData));
    int id = atoi(argc[1]);
    
    /* 1. Open database
       */
    char* database = build_full_path("db.sqlite");
    g_debug("%s\n", database);
    ev_db_init(data, database, NULL);
    free(database);
    event* ev = ev_mgr_new(NULL);
    if (!ev) return;
    
    ev_sel_get_by_id(id, ev, data, NULL);
    show_message(ev);
    ev_mgr_reminder_add(ev, time(NULL), data, NULL);
    
    ev_mgr_clear(ev, NULL);
    ev_db_close(data, NULL);
}
