/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */

/* Модуль Работы с удаленным хранилищем
 * Кодировщик : Епифанов С.А.
 * Дата последней модификации : 03.09.2009
 *
 */

#include <remote_storage/remote_storage.h>
#include <hildon/hildon-program.h>
#include <gtk/gtk.h>
#include <stdlib.h>


int ev_rcv_event_upload(RemoteStorage service, AppData *data, GError** error)
{        

    switch (service) {
        case GOOGLE_CALENDAR:
            if (protocols_google_event_upload(data, error) != NULL) {
		g_debug("Upload Error");
                return 1;
            }
            break;
/*Vkontakte will not been realised during this iteration. */
        case VKONTAKTE_CALENDAR:
	    printf("\nNot implemented yet\n");
	    break;

        default:
            return 1;
    } 
    
    return (0);
}


/**
 * Download events from service
 *
 * @param service    Service type
 * @param data       AppData data structure pointer
 * @param error      GError error structure pointer
 * @return Pointer on array of events
 * */

event* ev_rcv_event_download(RemoteStorage service, AppData *data, GError** error)
{

    event **events;
 
    switch (service) {
        case GOOGLE_CALENDAR:
	    events = protocols_google_events_download(data, error);
	    break;
/*Vkontakte will not been realised during this iteration. */ 
        case VKONTAKTE_CALENDAR:
	    g_debug("Not Implemented Yet");
            break;
        default:
            return NULL;
    }

    if (events == NULL) {
        return NULL;
    }

    return events;
}
