/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
#define CTF_LOG_FORMAT_USE_TIME
#define CTF_THROW_EXIT

#include "../CTF/src/ctf.h"
#include <ui/callbacks.h>
#include <settings/settings.h>
#include <appdata.h>
#include <time.h>

GLOBAL_DECL();
CTF_TEST_DATA_FILE_NAME_DECL;
CTF_STAT_FILE_NAME_DECL;

CTF_TEST_CASE(event_data_select_test1) {
    CTF_TEST_NAME("event_data_select_test1");
    AppData   *data;
    struct tm *date;
    int       i;
    data = create_data();
    conf_init(data);
    

    event* ev = ev_sel_search_by_field(F_DESC, "Meeting about project", data, NULL);
    CTF_CHECK_MSG(ev && (ev->id == 1 || ev->id == 2 || ev->id == 5), "Check ev_sel_search_by_field failed");
    ev_mgr_clear(ev, NULL);
    destroy_data(data);

}
