#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (c) 2010 Benoît HERVIER
# Licenced under GPLv3

"""PyFlakes Plugin : A KhtEditor plugin to check simple syntax error
   Using PyFlakes """

from PyQt4.QtCore import Qt, \
                         QObject

from PyQt4.QtGui import QTextEdit, \
                        QTextCursor

import dbus
import sys
try:
    from plugins_api import Plugin
except:
    from khteditor.plugins.plugins_api import Plugin

import compiler
from pyflakes.checker import Checker


class PyFlakes_plugin(Plugin, QObject):
    """ PyFlakes Plugin """

    capabilities = ['afterFileSave','afterFileOpen','beforeCursorPositionChanged']
    __version__ = '0.1'
    thread = None

    def do_afterFileOpen(self, parent):
        self.do_check(parent)

    def do_afterFileSave(self, parent):
        self.do_check(parent)

    def do_beforeCursorPositionChanged(self, parent):
        try:
            if hasattr(parent,'errors'):
                if len(parent.errors):
                    cur = parent.textCursor()
                    linepos = cur.blockNumber()
                    if linepos in parent.errors:
                        m_bus = dbus.SystemBus()
                        m_notify = m_bus.get_object('org.freedesktop.Notifications',
                                              '/org/freedesktop/Notifications')
                        iface = dbus.Interface(m_notify, 'org.freedesktop.Notifications')
                        iface.SystemNoteInfoprint(parent.errors[linepos])
        except:
            pass #No Dbus

    def do_check(self, parent):
        """ Do the pylint check and appends in the highlighter errors"""
        self.parent = parent

        #Limit to python source file
        if (not self.parent.filename.endswith('.py')) and (self.parent.filename.endswith('.pyw')):
            return

        doc = self.parent.document()

        errors = []
        rows = self.parent.errors.keys()
        self.parent.errors = {}
        for row in rows:
            self.parent.highlighter.rehighlightBlock(doc.findBlockByLineNumber(row))

        try:
            ast = compiler.parse(self.parent.toPlainText().encode('ascii', 'ignore'))
            c = Checker(ast, self.parent.filename)
            c.messages.sort(lambda a, b: cmp(a.lineno, b.lineno))
            for msg in c.messages:
                try:
                    args = msg.message_args
                    errors.append(((msg.lineno-1, 0, len(args[0])), msg.message % args, False))
                except Exception,err:
                    print err

        except SyntaxError, e:
            row, col = (e.lineno-1, e.offset-1)
            length = len(e.text)
            msg = e.msg
            errors.extend([((row, col, length), msg, True)])
        except Exception, err:
            import traceback
            exc_type, exc_value, exc_traceback = sys.exc_info()
            print 'Flakes plugin : %s' % repr(traceback.format_exception(exc_type, exc_value, \
                                      exc_traceback))

        selections = []
        for ((row, col, length), msg, is_fatal) in errors:
            self.parent.errors[row] = msg
            self.parent.highlighter.rehighlightBlock(doc.findBlockByLineNumber(row))

