#!/usr/bin/env python

"""PyFlakes Plugin : A KhtEditor plugin to check simple syntax error
   Using PyFlakes """

from PyQt4.QtCore import Qt, \
                         QObject

from PyQt4.QtGui import QTextEdit, \
                        QTextCursor

import dbus

try:
    from plugins_api import Plugin
except:
    from khteditor.plugins.plugins_api import Plugin

import compiler
from pyflakes.checker import Checker

class PyFlakes_plugin(Plugin, QObject):
    """ PyFlakes Plugin """
    capabilities = ['afterFileSave','afterFileOpen','beforeCursorPositionChanged']
    __version__ = '0.1'
    thread = None

    def do_afterFileOpen(self, parent):
        self.do_check(parent)

    def do_afterFileSave(self, parent):
        self.do_check(parent)

    def do_beforeCursorPositionChanged(self, parent):
        if hasattr(parent,'errors'):
            if len(parent.errors):
                cur = parent.textCursor()
                linepos = cur.blockNumber()
                if linepos in parent.errors:
                    m_bus = dbus.SystemBus()
                    m_notify = m_bus.get_object('org.freedesktop.Notifications',
                                          '/org/freedesktop/Notifications')
                    iface = dbus.Interface(m_notify, 'org.freedesktop.Notifications')
                    iface.SystemNoteInfoprint(parent.errors[linepos])

    def do_check(self, parent):
        """ Hook to install the pylint toolbar button"""
        self.parent = parent

        #Limit to python source file
        if (not self.parent.filename.endswith('.py')) and (self.parent.filename.endswith('.pyw')):
            return

        errors = []
        self.parent.errors = {}
        try:
            ast = compiler.parse(self.parent.toPlainText().encode())
            c = Checker(ast, self.parent.filename)
            c.messages.sort(lambda a, b: cmp(a.lineno, b.lineno))
            for msg in c.messages:
                args = msg.message_args
                errors.append( ((msg.lineno-1, 0, len(args[0])), msg.message % args, False))

        except SyntaxError, e:
            row, col = (e.lineno-1, e.offset-1)
            length = len(e.text)
            msg = e.msg
            errors.extend[ ((row, col, length), msg, True) ]
        except Exception, err:
            print err

        doc = self.parent.document()

        selections = []
        for ((row, col, length), msg, is_fatal) in errors:
            self.parent.errors[row] = msg
            block = doc.findBlockByNumber(row)
            length = block.length()
            if length - col < 2:
                col = 0
            block_col = block.position()
            start_col = block_col + col
            end_col = block_col
            if end_col <= start_col:
                start_col = block_col
                end_col = block_col + block.length()

            _selection =  QTextEdit.ExtraSelection()
            _selection.cursor = self.parent.textCursor()
            _selection.cursor.setPosition(start_col)
            _selection.cursor.movePosition( QTextCursor.NextCharacter,
                             QTextCursor.KeepAnchor,end_col-start_col)

            # XXX: does not seem to work
            # Related to http://bugreports.qt.nokia.com/browse/QTBUG-6762 ?
            #sel.format.setToolTip(msg)
            if is_fatal:
                _selection.format.setForeground(Qt.white)
                _selection.format.setBackground(Qt.red)
            else:
                _selection.format.setForeground(Qt.white)
                _selection.format.setBackground(Qt.red)
            _selection.format.setToolTip(msg)
            selections.append(_selection)
        if (len(selections)>0) and (not self.parent.qt18720):
            selections.extend(self.parent.extraSelections())
            self.parent.setExtraSelections(selections)
