/**************************************************************************
 *  Kchmviewer for Maemo5 - a CHM file viewer with broad language support *
 *  Port of KChmViewer ( www.kchmviewer.net ) to mobile platforms         *
 *  Copyright (C) 2009-2010 Max Kiva , max.kiva@gmail.com                 *
 *                                                                        *
 *  This program is free software: you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation, either version 3 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 **************************************************************************/
#ifndef __TOOLBARWIDGET_H__
#define __TOOLBARWIDGET_H__
#include <QWidget>

class QHBoxLayout;
class QPushButton;

class ToolBarWidget : public QWidget
{
  Q_OBJECT
  public:
    ToolBarWidget( QWidget* parent );
    virtual ~ToolBarWidget();


    void enableButtons( bool enable = true );

  signals:

    void contents();
    void nextPage();
    void prevPage();
    void zoomOut();
    void zoomIn();
    void fullScreen();

  private slots:
    void clickedOpenFile(); 
    void clickedRecentDocs(); 
    void clickedContents(); 
    void clickedBookmarks(); 
    void clickedFind(); 
    void clickedZoomOut();
    void clickedZoomIn();
    void clickedNextPage();
    void clickedPrevPage();
    void clickedFullScreen();

  private:

    enum { EOpen, ERecentDocs, EContents, EBookmarks, EFind, EPrev, ENext, EZoomIn, EZoomOut, EFullScreen, ENumButtons };
    
    QHBoxLayout* layout_;
    QPushButton* btns_[ ENumButtons ];
    
};


#endif

