/**************************************************************************
 *  Kchmviewer for Maemo5 - a CHM file viewer with broad language support *
 *  Copyright (C) 2009-2010 Max Kiva , max.kiva@gmail.com                 *
 *                                                                        *
 *  This program is free software: you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation, either version 3 of the License, or     *
 *  (at your option) any later version.                                   *
 *															                                  	      *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 **************************************************************************/
#include <QtGui>
#include <qpixmap.h>
#include "mainwindow.h"
#include "toolbarwidget.h"
#include "resources.h"



/***********************************************************
 *
 */
ToolBarWidget::ToolBarWidget( QWidget* parent )
  : QWidget(parent),
    layout_( new QHBoxLayout(this) )
{
  btns_[EOpen] = new QPushButton( QPixmap( iconOpen() ), 0, this );
  connect( btns_[EOpen], SIGNAL(clicked()), this , SLOT(clickedOpenFile()) );
  
  btns_[ERecentDocs] = new QPushButton( QPixmap( iconRecentDocs() ), 0, this );
  connect( btns_[ERecentDocs], SIGNAL(clicked()), this , SLOT(clickedRecentDocs()) );
  
  btns_[EContents] = new QPushButton( QPixmap( iconContents() ), 0, this );
  connect( btns_[EContents], SIGNAL(clicked()), this , SLOT(clickedContents()) );


  btns_[EBookmarks] = new QPushButton( QPixmap( QPixmap(iconBookmarks()) ), 0, this );
  connect( btns_[EBookmarks], SIGNAL(clicked()), this , SLOT(clickedBookmarks()) );

  btns_[EFind] = new QPushButton( QPixmap( QPixmap(iconSearch()) ), 0, this );
  connect( btns_[EFind], SIGNAL(clicked()), this , SLOT(clickedFind()) );


  btns_[EPrev] = new QPushButton( QPixmap(iconBack()), 0, this );
  connect( btns_[EPrev], SIGNAL(clicked()), this , SLOT(clickedPrevPage()) );
  
  btns_[ENext] = new QPushButton( QPixmap( iconForward() ), 0, this );
  connect( btns_[ENext], SIGNAL(clicked()), this , SLOT(clickedNextPage()) );
  
  btns_[EZoomIn] = new QPushButton( QPixmap(iconZoomIn()), 0, this );
  connect( btns_[EZoomIn], SIGNAL(clicked()), this , SLOT(clickedZoomIn()) );
  
  btns_[EZoomOut] = new QPushButton( QPixmap(iconZoomOut() ), 0, this );
  connect( btns_[EZoomOut], SIGNAL(clicked()), this , SLOT(clickedZoomOut()) );
  
  btns_[EFullScreen] = new QPushButton( QPixmap( iconFullScreen() ), 0, this );
  connect( btns_[EFullScreen], SIGNAL(clicked()), this , SLOT(clickedFullScreen()) );

  for( int i =0 ; i < ENumButtons; ++i )
  {
    btns_[i]->show();
    if(i > 1)
    {
      btns_[i]->setEnabled(false);
    }
    btns_[i]->setFlat(true);
    layout_->addWidget( btns_[i] );
  }

}

/*****************************************************************************
 *
 */
ToolBarWidget::~ToolBarWidget()
{
  for( int i =0 ; i < ENumButtons; ++i )
  {
      delete btns_[i];
  }
  delete layout_;
}

void ToolBarWidget::enableButtons( bool enable )
{

  for( int i =0 ; i < ENumButtons; ++i )
  {
      btns_[i]->setEnabled(enable);
  }
}


/*****************************************************************************
 *
 */
void ToolBarWidget::clickedOpenFile()
{
 MainWindow* wnd = dynamic_cast<MainWindow*>(parentWidget()); 

 wnd->doOpenFile();
 
}
/*****************************************************************************
 *
 */
void ToolBarWidget::clickedContents()
{
  MainWindow* wnd = dynamic_cast<MainWindow*>(parentWidget()); 
  wnd->doOpenTableOfContents();
}

/*****************************************************************************
 *
 */
void ToolBarWidget::clickedRecentDocs()
{
  MainWindow* wnd = dynamic_cast<MainWindow*>(parentWidget()); 
  wnd->doRecentDocs();
}
void ToolBarWidget::clickedFind()
{
  MainWindow* wnd = dynamic_cast<MainWindow*>(parentWidget()); 
  wnd->doFind();
}
void ToolBarWidget::clickedBookmarks()
{
  MainWindow* wnd = dynamic_cast<MainWindow*>(parentWidget()); 
  wnd->doBookmarks();
}
void ToolBarWidget::clickedZoomOut()
{
  MainWindow* wnd = dynamic_cast<MainWindow*>(parentWidget()); 
  wnd->doZoomOut();
}
void ToolBarWidget::clickedZoomIn()
{
  MainWindow* wnd = dynamic_cast<MainWindow*>(parentWidget()); 
  wnd->doZoomIn();
}
void ToolBarWidget::clickedNextPage()
{
  MainWindow* wnd = dynamic_cast<MainWindow*>(parentWidget()); 
  wnd->doNextPage();
}
void ToolBarWidget::clickedPrevPage()
{
  MainWindow* wnd = dynamic_cast<MainWindow*>(parentWidget()); 
  wnd->doPrevPage();
}

void ToolBarWidget::clickedFullScreen()
{
  MainWindow* wnd = dynamic_cast<MainWindow*>(parentWidget()); 
  wnd->doFullScreenOn();
}
