/**************************************************************************
 *  Kchmviewer for Maemo5 - a CHM file viewer with broad language support *
 *  Port of KChmViewer ( www.kchmviewer.net ) to mobile platforms         *
 *  Copyright (C) 2009-2010 Max Kiva , max.kiva@gmail.com                 *
 *                                                                        *
 *  This program is free software: you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation, either version 3 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 **************************************************************************/
#ifndef __RESOURCES_H__
#define __RESOURCES_H__

#include <QApplication>
#include <QDesktopWidget>

const char* iconTag();
const char* iconBookmarks();
const char* iconBookmark();
const char* iconRecentDocs();

const char* iconSearch();

const char* iconBack();
 
const char* iconForward();
 
const char* iconZoomIn();

const char* iconZoomOut();

const char* iconFullScreen();

const char* iconStop();

const char* iconOpen();

const char* iconContents();

const char* iconChecked();
const char* iconUnchecked();

inline static const QString& appName()
{
  static QString name = "kchmviewer-moma";
  return name;
}


/***************************************************************************
 */
inline static size_t screenWidth()
{
#ifdef MAEMO  
  return QApplication::desktop()->width();
#else
  return 800;
#endif  
}

/***************************************************************************
 */
inline static size_t screenHeight()
{
#ifdef MAEMO  
  return QApplication::desktop()->height();
#else
  return 480;
#endif  
}

/***************************************************************************
 */
inline static size_t notificationAreaHeight()
{
  const size_t NOTIF_AREA_HEIGHT = 
#ifdef MAEMO  
  56;
#else
  0;
#endif  
  return NOTIF_AREA_HEIGHT;
}

/***************************************************************************
 */
inline static size_t toolbarHeight()
{
  const size_t TOOLBAR_HEIGHT = 70;
  return TOOLBAR_HEIGHT;
}

/***************************************************************************
 */
inline static size_t toolbarX()
{
  const size_t TOOLBAR_X = 0;
  return TOOLBAR_X;
}
/***************************************************************************
 */
inline static size_t toolbarY()
{
  const int TOOLBAR_Y = screenHeight() - 
                        notificationAreaHeight() - 
                        toolbarHeight(); 
  return TOOLBAR_Y;
}



#endif
