/**************************************************************************
 *  Kchmviewer for Maemo5 - a CHM file viewer with broad language support *
 *  Copyright (C) 2009-2010 Max Kiva , max.kiva@gmail.com                 *
 *                                                                        *
 *  This program is free software: you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation, either version 3 of the License, or     *
 *  (at your option) any later version.                                   *
 *															                                  	      *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 **************************************************************************/
#include <iostream>
#include <QtGui>
#include <qpixmap.h>
#include "mainwindow.h"
#include "toolbarwidget.h"

#include "openfile.xpm"
#include "contents.xpm"
#include "fullscreen.xpm"
#include "nextpage.xpm"
#include "prevpage.xpm"
#include "zoomin.xpm"
#include "zoomout.xpm"


/***********************************************************
 *
 */
ToolBarWidget::ToolBarWidget( QWidget* parent )
  : QWidget(parent),
    layout_( new QHBoxLayout(this) )
{
  btns_[0] = new QPushButton( QPixmap( openfile_xpm ), 0, this );
  connect( btns_[0], SIGNAL(clicked()), this , SLOT(clickedOpenFile()) );
  btns_[1] = new QPushButton( QPixmap( contents_xpm ), 0, this );
  connect( btns_[1], SIGNAL(clicked()), this , SLOT(clickedContents()) );
  btns_[2] = new QPushButton( QPixmap( prevpage_xpm ), 0, this );
  connect( btns_[2], SIGNAL(clicked()), this , SLOT(clickedPrevPage()) );
  btns_[3] = new QPushButton( QPixmap( nextpage_xpm ), 0, this );
  connect( btns_[3], SIGNAL(clicked()), this , SLOT(clickedNextPage()) );
  btns_[4] = new QPushButton( QPixmap( zoomin_xpm ), 0, this );
  connect( btns_[4], SIGNAL(clicked()), this , SLOT(clickedZoomIn()) );
  btns_[5] = new QPushButton( QPixmap( zoomout_xpm ), 0, this );
  connect( btns_[5], SIGNAL(clicked()), this , SLOT(clickedZoomOut()) );
  btns_[6] = new QPushButton( QPixmap( fullscreen_xpm ), 0, this );
  connect( btns_[6], SIGNAL(clicked()), this , SLOT(clickedFullScreen()) );

  for( int i =0 ; i < BUTTON_NUM; ++i )
  {
    if(i)
    {
      btns_[i]->setEnabled(false);
    }
    btns_[i]->setFlat(true);
    layout_->addWidget( btns_[i] );
  }

}

/*****************************************************************************
 *
 */
ToolBarWidget::~ToolBarWidget()
{
  for( int i =0 ; i < BUTTON_NUM; ++i )
  {
      delete btns_[i];
  }
  delete layout_;
}

void ToolBarWidget::enableButtons()
{

  for( int i =0 ; i < BUTTON_NUM; ++i )
  {
      btns_[i]->setEnabled(true);
  }
}


/*****************************************************************************
 *
 */
void ToolBarWidget::clickedOpenFile()
{
 MainWindow* wnd = dynamic_cast<MainWindow*>(parentWidget()); 

 wnd->doOpenFile();
 
}
/*****************************************************************************
 *
 */
void ToolBarWidget::clickedContents()
{
  MainWindow* wnd = dynamic_cast<MainWindow*>(parentWidget()); 
  wnd->doOpenTableOfContents();
}

void ToolBarWidget::clickedZoomOut()
{
  MainWindow* wnd = dynamic_cast<MainWindow*>(parentWidget()); 
  wnd->doZoomOut();
}
void ToolBarWidget::clickedZoomIn()
{
  MainWindow* wnd = dynamic_cast<MainWindow*>(parentWidget()); 
  wnd->doZoomIn();
}
void ToolBarWidget::clickedNextPage()
{
  MainWindow* wnd = dynamic_cast<MainWindow*>(parentWidget()); 
  wnd->doNextPage();
}
void ToolBarWidget::clickedPrevPage()
{
  MainWindow* wnd = dynamic_cast<MainWindow*>(parentWidget()); 
  wnd->doPrevPage();
}

void ToolBarWidget::clickedFullScreen()
{
  MainWindow* wnd = dynamic_cast<MainWindow*>(parentWidget()); 
  wnd->doFullScreenOn();
}
