/*
  Kandis - A tea steepming timer.
  Copyright (C) 2009  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "TeeEdit.h"

#include <Lum/Base/L10N.h>

#include <Lum/Label.h>
#include <Lum/Panel.h>
#include <Lum/String.h>
#include <Lum/TimeSpan.h>

TeeEdit::TeeEdit(Lum::Model::String* name,
                 Lum::Model::Number* seconds)
 : name(name),
   seconds(seconds),
   okAction(new Lum::Model::Action()),
   success(false)
{
  name->Push();
  seconds->Push();

  Observe(name);
  Observe(okAction);
  Observe(GetClosedAction());
}

TeeEdit::~TeeEdit()
{
  seconds->Pop();
  name->Pop();
}

Lum::Object* TeeEdit::GetContent()
{
  return Lum::Label::Create(true,true)
  ->AddLabel(_(L"DLG_TEA_LABEL_NAME",L"Name:"),
             Lum::String::Create(name,true,false))
  ->AddLabel(_(L"DLG_TEA_LABEL_TIMESPAN",L"Time:"),
             Lum::TimeSpan::Create(seconds,false,false));
}

void TeeEdit::GetActions(std::vector<Lum::Dlg::ActionInfo>& actions)
{
  Lum::Dlg::ActionDialog::CreateActionInfosOkCancel(actions,okAction,GetClosedAction());
}

bool TeeEdit::Success() const
{
  return success;
}

void TeeEdit::Resync(Lum::Base::Model *model,
                     const Lum::Base::ResyncMsg& msg)
{
  if (model==GetClosedAction() &&
      GetClosedAction()->IsFinished()) {
    Exit();
  }
  else if (model==name) {
    if (name->Get().empty()) {
      okAction->Disable();
    }
    else {
      okAction->Enable();
    }
  }
  else if (model==okAction &&
           okAction->IsFinished()) {
    success=true;
    name->Save();
    seconds->Save();
    Exit();
  }

  Lum::Dlg::ActionDialog::Resync(model,msg);
}

