#ifndef SELECTOR_H
#define SELECTOR_H

/*
  Kandis - A tea steepming timer.
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Base/String.h>

#include <Lum/Dlg/ActionDialog.h>

#include <Lum/Model/Action.h>
#include <Lum/Model/Integer.h>
#include <Lum/Model/Selection.h>
#include <Lum/Model/String.h>
#include <Lum/Model/Table.h>

#include "Configuration.h"

typedef Lum::Model::StdRefTable<Tea,std::vector<Tea> > TeasModel;
typedef Lum::Base::Reference<TeasModel>                TeasModelRef;

class TeasDataProvider : public TeasModel::DataProvider
{
private:
  std::wstring GetTimeString(size_t minutes, size_t seconds) const
  {
    std::wstring tmp;

    tmp=Lum::Base::NumberToWString(minutes);
    tmp.append(L":");
    if (seconds<10) {
      tmp.append(L"0");
    }
    tmp.append(Lum::Base::NumberToWString(seconds));

    return tmp;
  }

public:
  std::wstring GetString(const TeasModel::Iterator& iter, size_t column) const
  {
    switch (column) {
    case 1:
      return iter->name;
    case 2:
      return GetTimeString(iter->minutes,iter->seconds);
    default:
      assert(false);
    }
  }
};

class Selector : public Lum::Dlg::ActionDialog
{
private:
  Lum::Model::StringRef              value;
  Lum::Model::IntRef                 minutes;
  Lum::Model::IntRef                 seconds;
  TeasModelRef                       list;
  Lum::Model::SingleLineSelectionRef selection;

  Lum::Model::ActionRef              addAction;
  Lum::Model::ActionRef              updateAction;
  Lum::Model::ActionRef              removeAction;
  Lum::Model::ActionRef              okAction;

public:
  Selector(Lum::Model::Int* minutes, Lum::Model::Int *seconds);

  Lum::Object* GetContent();
  void GetActions(std::vector<Lum::Dlg::ActionInfo>& actions);

  void Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg);
};

#endif
