/*

Kana of The Day -- Japanese kana learning application for Maemo Fremantle.
Copyright (C) 2012 M. Hossein Azadmanesh (mhazadmanesh2009@gmail.com)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

/*
 * IMPORTANT: Most parts of this file are taken from different source files of the `kanatest` project
 *            and therefor are published by the same license.
 *
 *            There have been modifications.
 *
 *            The license for `kanatest` files follows:
 *
 */

/*
 * Kanatest
 *
 * Copyright (C) 2001-2004, 2006 Tomasz Maka <pasp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#define     NUMBER_OF_SIGNS     104

//ADDED: User-defined set is removed
//#define     KANA_SET_NAMES      15
#define     KANA_SET_COUNT      14

enum KanaTypes
{
    ROMAJI,
    HIRAGANA,
    KATAKANA
};

const char* get_kana_sign(int index, int kana_type /*, gboolean translated*/);
int get_kana_set_len(int set);
const char* get_kana_set_name (int set);

void seed_random();
void generate_kanaset (int set, int*& permtab);
void generate_permutation (int set, int*& permtab);
