/*

Kana of The Day -- Japanese kana learning application for Maemo Fremantle.
Copyright (C) 2012 M. Hossein Azadmanesh (mhazadmanesh2009@gmail.com)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

#include "KanaOTDHomeWidget.h"
#include "qmaemo5homescreenadaptor.h"

#include <QApplication>
#include <QFileInfo>
#include <QtDBus>

int main(int argc, char* argv[])
{
    QApplication a(argc, argv);

    bool horizontal = false;
    if (QFileInfo(QString(argv[0])).fileName() == QString("kanaotdhomewidgeth"))
        horizontal = true;
    else //Both kanaotdhomewidgetV and fallback
        horizontal = false;

    QString directionchar(horizontal ? "h" : "v");

    KanaOTDHomeWidget w(horizontal);
    QMaemo5HomescreenAdaptor* adaptor = new QMaemo5HomescreenAdaptor(&w);
    adaptor->setSettingsAvailable(false);

    QDBusConnection connection = QDBusConnection::sessionBus();
    if (!connection.isConnected())
    {
        qWarning("Cannot connect to the D-Bus session bus.");
        exit(1);
    }
    if (!connection.registerService(QString("org.kanaoftheday.homewidget") + directionchar))
    {
        qWarning("%s", qPrintable(connection.lastError().message()));
        exit(2);
    }
    if (!connection.registerObject(QString("/org/kanaoftheday/homewidget") + directionchar,
                                   &w, QDBusConnection::ExportScriptableSlots))
    {
        qWarning("%s", qPrintable(connection.lastError().message()));
        exit(3);
    }

    connection.connect("org.kanaoftheday.kanaotd", "/org/kanaoftheday/kanaotd",
                       "org.kanaoftheday.kanaotd", "PropagateKana",
                       &w, SLOT(UpdateKana(int)));

    w.show();
    return a.exec();
}
