/*

Kana of The Day -- Japanese kana learning application for Maemo Fremantle.
Copyright (C) 2012 M. Hossein Azadmanesh (mhazadmanesh2009@gmail.com)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

//TODO: If program is running under "user" user ONLY in PORTRAIT mode and
//      you deploy the program to device, the new process throws a SEGFAULT!

#include "MainWindow.h"

#include <QApplication>
#include <QtDBus>

//todo: auto start the horizontal widget at first run?

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);

    //We put the first two before the mainwindow constructor, and you shall not see the
    //  extra instances of app while loading; they'll just exit. No need to send a message
    //  before exiting, since D-Bus message launch application will handle it.
    QDBusConnection connection = QDBusConnection::sessionBus();
    if (!connection.isConnected())
    {
        qWarning("Cannot connect to the D-Bus session bus.");
        exit(1);
    }
    if (!connection.registerService("org.kanaoftheday.kanaotd"))
    {
        qWarning("%s", qPrintable(connection.lastError().message()));
        exit(2);
    }

    MainWindow mainWindow;
    mainWindow.setOrientation(MainWindow::ScreenOrientationAuto);
    mainWindow.showExpanded();

    if (!connection.registerObject("/org/kanaoftheday/kanaotd", &mainWindow,
                                   QDBusConnection::ExportScriptableSlots))
    {
        qWarning("%s", qPrintable(connection.lastError().message()));
        exit(3);
    }

    return app.exec();
}
