/*

Kana of The Day -- Japanese kana learning application for Maemo Fremantle.
Copyright (C) 2012 M. Hossein Azadmanesh (mhazadmanesh2009@gmail.com)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

#include "AboutDialog.h"
#include "ScrollableLabel.h"

#include <QBoxLayout>
#include <QComboBox>
#include <QFont>
#include <QTabWidget>

AboutDialog::AboutDialog(QWidget *parent) :
    QDialog(parent)
{
    setWindowTitle("About Kana of The Day");

    QString aboutText =
            "<b><font size=\"6\">Kana of The Day</font></b><br/>\n"
            "Version 1.0<br/>\n"
            "Copyright (C) 2012 M. Hossein Azadmanesh<br/>\n"
            "<a href=\"mailto:mhazadmanesh2009@gmail.com\">mhazadmanesh2009@gmail.com</a><br/>\n"
            "<br/>\n"
            "Kana database and portions of code are taken from the <b>kanatest</b> project "
            "(<a href=\"http://clayo.org/kanatest/\">http://clayo.org/kanatest/</a>),<br/>\n"
            "Copyright (C) 2001-2004, 2006-2009 Tomasz Maka (<a href=\"mailto:pasp@users.sourceforge.net\">"
            "pasp@users.sourceforge.net</a>)<br/>\nThanks to contributors there.";

    QString licenseText =
            "This program uses original code and code from the kanatest project. The license for "
            "both follows.\n"
            "\n\n"
            "Kana of The Day -- Japanese kana learning application for Maemo Fremantle.\n"
            "Copyright (C) 2012 M. Hossein Azadmanesh (mhazadmanesh2009@gmail.com)\n"
            "\n"
            "This program is free software; you can redistribute it and/or\n"
            "modify it under the terms of the GNU General Public License\n"
            "as published by the Free Software Foundation; either version 2\n"
            "of the License, or (at your option) any later version.\n"
            "\n"
            "This program is distributed in the hope that it will be useful,\n"
            "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
            "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
            "GNU General Public License for more details.\n"
            "\n"
            "You should have received a copy of the GNU General Public License\n"
            "along with this program; if not, write to the Free Software\n"
            "Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.\n"
            "\n\n"
            "Kanatest\n"
            "\n"
            "Copyright (C) 2001-2004, 2006 Tomasz Maka <pasp@users.sourceforge.net>\n"
            "\n"
            "This program is free software; you can redistribute it and/or modify\n"
            "it under the terms of the GNU General Public License as published by\n"
            "the Free Software Foundation; either version 2 of the License, or\n"
            "(at your option) any later version.\n"
            "\n"
            "This program is distributed in the hope that it will be useful,\n"
            "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
            "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
            "GNU General Public License for more details.\n"
            "\n"
            "You should have received a copy of the GNU General Public License\n"
            "along with this program; if not, write to the Free Software\n"
            "Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.";

    QString donateText =
            "Well I guess you can't donate since you don't live in Iran. ;-)\n\n"
            "However you can *help yourself* in other ways. Some suggestions are:\n\n"
            " - Your family is MORE IMPORTANT than work, friends, pets and computers. "
            "*Your family* is the one thing in your life you should invest in. Please pay more attention!\n"
            " - Increase your knowledge. Don't try to be a simple, ignorant person. Otherwise "
            "your brain remains hesitating pointlessly between so many conflicting ideas and doctrines.\n"
            " - Learn to find reasons behind everything. Do NOT blindly be in control of anybody, "
            "including your and other governments.\n"
            " - Do not blindly believe everything media says; Iran or any other country is NOT "
            "how they show you. The way media broadcasts news is the way their owners think, or maybe "
            "the way they think things should be depicted. Please increase the capacity of your brain!"
            "\n\n"
            "Alternatively, you could also donate to the `kanatest` project, which I got the data from. (The "
            "author suggests sending postcards to him, install kanatest on Maemo device or on your PC for "
            "more info.)";

    QTabWidget* tw = new QTabWidget();
    tw->setDocumentMode(true);
    tw->addTab(new ScrollableLabel(aboutText), "About");
    tw->addTab(new ScrollableLabel(licenseText), "License");
    tw->addTab(new ScrollableLabel(donateText), "Donate");

    QVBoxLayout* mainLayout = new QVBoxLayout();
    mainLayout->addWidget(tw);
    setLayout(mainLayout);
}

AboutDialog::~AboutDialog()
{

}
