/*

Kana of The Day -- Japanese kana learning application for Maemo Fremantle.
Copyright (C) 2012 M. Hossein Azadmanesh (mhazadmanesh2009@gmail.com)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

#include "IntroDialog.h"
#include "ScrollableLabel.h"

#include <QBoxLayout>

IntroDialog::IntroDialog(bool showWelcome, QWidget *parent) :
    QDialog(parent)
{
    setWindowTitle("Short Introduction");

    QString introText = "";
    if (showWelcome)
        introText = "<b>Welcome To Kana of The Day!</b><br/><br/>\n";
    introText +=
        "You can memorize one hiragana and one katakana every day (or more than one, if you wish).<br/><br/>\n"
        "You can also restrict the kanas to small groups via the <i>Choose Kana Set</i> menu.<br/><br/>\n"
        "If you wish to memorize more than one kana, you can use <i>Previous Kana</i> "
        "and <i>Next Kana</i> buttons, press Left arrow or Right arrow key on keyboard, or "
        "<b>SWIPE your finger on the screen left and right</b>.<br/><br/>\n"
        "You can test your knowledge by clicking on the <b>[x]</b> button besides the Romaji field to hide it."
        "<br/><br/>\nHowever, if you want a more advanced flash-card like repetition and exam program, "
        "I recommend you use <b>kanatest</b> application besides this program.<br/><br/>\n"
        "The kana sets (categories) used in this program are exactly the same as those in <b>kanatest</b>, "
        "so you can use this program to learn kana, then use <b>kanatest</b> to test knowledge.";

    QVBoxLayout* mainLayout = new QVBoxLayout();
    mainLayout->addWidget(new ScrollableLabel(introText));
    setLayout(mainLayout);
}

IntroDialog::~IntroDialog()
{

}
