/*
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef T9TRIE_H
#define T9TRIE_H

#include <QListWidgetItem>
#include <QContactId>
#include <QDebug>

class T9Trie
{
private:
    // 10 is the magical number because that is the number of digits in base 10 :)
    const static int NUM_CHILDREN = 10;
public:
    T9Trie() :list(), children() {};

    ~T9Trie()
    {
        reset();
    }

    void reset()
    {
        for ( int i=0; i < NUM_CHILDREN; i++ )
        {
            delete children[i];
            children[i] = NULL;
        }
    };
    bool insert ( const QChar* key, QtMobility::QContactLocalId id );
    QSet<QtMobility::QContactLocalId> lookup ( const QChar* key );

	static QString T9Value (const QString& str);
	
protected:
	static int T9Value ( const QChar& c );

    QSet<QtMobility::QContactLocalId> list;
    T9Trie* children[NUM_CHILDREN];
};

#endif // T9TRIE_H
