#include "qmaemo5homescreenadaptor.h"
#include <QtGui/QApplication>
#include <QtGui/QMainWindow>
#include <QtGui/QGraphicsView>
#include <QtGui/QGraphicsScene>
#include <QtGui/QGraphicsProxyWidget>
#include <QtGui/QVBoxLayout>
#include <QtGui/QMenuBar>
#include "k9call.h"
#include "contactsthreadworker.h"

int main(int argc, char *argv[])
{
	QApplication a(argc, argv);
	
	// General setup
	qRegisterMetaType<QList <QtMobility::QContact> >("QList<QtMobility::QContact>");
	qRegisterMetaType<QList <QtMobility::QContact> >("QList<QtMobility::QContactLocalId>");
	
	k9call *w = new k9call();
	QGraphicsScene* scene = new QGraphicsScene();
	QGraphicsProxyWidget *proxy = scene->addWidget(w);
	QGraphicsView* view = new QGraphicsView(scene);

	// Setup the Widget
	proxy->setMaximumSize(400,600);
	proxy->setMinimumSize(400,600);
	view->setFixedSize(600,400);
	view->centerOn(proxy);
	view->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	view->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	view->rotate(-90);

	view->setAttribute(Qt::WA_TranslucentBackground);
	view->setStyleSheet("background: transparent");

	if(a.argc() > 1 && QString(a.argv()[1]) == "-d") {
		QMainWindow win;
		
		// Setup Layout
		QWidget* layoutWidget = new QWidget(&win);
		QVBoxLayout* layout = new QVBoxLayout(layoutWidget);
		layout->setAlignment(Qt::AlignCenter);
		layout->addWidget(view);
		win.setCentralWidget(layoutWidget);
		
		// Setup Menu
		QAction* settings = win.menuBar()->addAction("&Settings");
		QObject::connect(settings, SIGNAL(triggered()), w, SLOT(openSettings()));

		// Setup Window
		win.setAttribute(Qt::WA_TranslucentBackground);
		win.show();
		return a.exec();
	}
	else {
		// Attach the adaptor
		QMaemo5HomescreenAdaptor adaptor(view);
		adaptor.setSettingsAvailable(true);
		QObject::connect(&adaptor, SIGNAL(settingsRequested()), w, SLOT(openSettings()));

		view->show();
		return a.exec();
	}
}
