#include "contactsthreadworker.h"
#include "k9call.h"

ContactsThreadWorker::ContactsThreadWorker(k9call* k)
    : QThread(0), m_Manager()
{
	// Setup connections
	connect(this, SIGNAL(updateContacts(QList<QtMobility::QContact>)), 
	        k, SLOT(updateContacts(QList<QtMobility::QContact>)), Qt::QueuedConnection);

	// Setup thread
	this->start(IdlePriority);
	this->moveToThread(this);
}

void ContactsThreadWorker::run()
{
    this->exec();
}

void ContactsThreadWorker::syncContacts()
{
	qDebug() << "Sync Contacts ThreadId " << (int)QThread::currentThreadId();
	qDebug() << "Got manager...";
	QContactFetchHint hint;
	QContactFetchHint::OptimizationHints optimizations = 0;
	optimizations |= QContactFetchHint::NoBinaryBlobs;
	optimizations |= QContactFetchHint::NoRelationships;
	hint.setOptimizationHints(optimizations);
	qDebug() << "Fetching...";
	emit updateContacts(m_Manager.contacts(QList<QContactSortOrder>(), hint));
}

void ContactsThreadWorker::syncContactIds()
{
	qDebug() << "Sync Id ThreadId " << (int)QThread::currentThreadId();
    QContactManager m;
	emit updateContactIds(m.contactIds());
}
