#ifndef K9CALL_H
#define K9CALL_H

#include <QContactManager>
#include <QContactPhoneNumber>
#include <QContactId>
#include <QTimer>
#include <QHash>
#include <QPair>

#include "ui_k9call.h"
#include "ui_settings.h"
#include "t9trie.h"
#include "contactsthreadworker.h"

using namespace QtMobility;

class k9call : public QWidget
{
    Q_OBJECT

public slots:
    void call();
	void clear();
    void populateList();
    void insertChar();
    void updateQuery();
	void nextContact();
	void nextPhoneNumber();
	void syncContacts();
    void updateContacts(QList<QtMobility::QContact> contacts);
	void openSettings();
	void closeSettings();

public:	

    explicit k9call(QWidget *parent = 0);

private:
    enum KeypadButton { KEYPAD_BUTTON_1, KEYPAD_BUTTON_2, KEYPAD_BUTTON_3,
                        KEYPAD_BUTTON_4, KEYPAD_BUTTON_5, KEYPAD_BUTTON_6,
                        KEYPAD_BUTTON_7, KEYPAD_BUTTON_8, KEYPAD_BUTTON_9,
                        KEYPAD_BUTTON_STAR, KEYPAD_BUTTON_0, KEYPAD_BUTTON_HASH };

    //Members
	Ui_K9Call ui;
	QDialog* m_Settings;
	
	// Styles
    QString m_StyleLetters;
    QString m_StyleCallButton;
    QString m_StyleClearButton;

	// Tries
    T9Trie m_FirstNameTrie;
    T9Trie m_LastNameTrie;

		QHash<QString, QPair<QContactLocalId, QContactLocalId> > m_Accel;

	QList<QContactLocalId> m_ActiveList;
	QList<QContactLocalId>::const_iterator m_ActiveListItr;
	
	QList<QContactPhoneNumber> m_PhoneNumbers;
	QList<QContactPhoneNumber>::const_iterator m_PhoneNumbersItr;

	QContactManager* m_Manager;
	ContactsThreadWorker* m_ContactWorker;
	bool m_Initialized;
	
	QString m_SearchString;

	enum Roles { ContactIdRole = 1024 };

    // Methods
    bool getExternalStyleSheet(QString &styleSheet, QString fileName);
    bool doesPhoneNumberExist(QContact *i_Contact);
    void getContactDetails(QString contactName);
    void makeDbusGSMCall(QString number);
    void createStyle();

    // UI Methods
    void setupUi();
    void setupButton(KeypadButton idx, QPushButton* button);
	
	// Cache methods
	void saveCache( const QList<QContact>& contacts);
	bool loadCache();
};

#endif // K9call_H
