/*
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef T9TRIE_H
#define T9TRIE_H

#include <QListWidgetItem>
#include <QContactId>

class T9Trie
{
private:
    // 10 is the magical number because that is the number of digits in base 10 :)
    const static int NUM_CHILDREN = 10;
public:
    T9Trie() :list(), children() {};

    ~T9Trie()
    {
        reset();
    }

    void reset()
    {
        for ( int i=0; i < NUM_CHILDREN; i++ )
        {
            delete children[i];
            children[i] = NULL;
        }
    };
    bool insert ( const QChar* key, QtMobility::QContactLocalId id );
    QSet<QtMobility::QContactLocalId> lookup ( const QChar* key );

	static QString T9Value (const QString& str);
	
protected:
	static int T9Value ( const QChar& c )
    {
        switch ( c.toLower().toAscii() )
        {
        case '1':
            return 1;
        case '2':
        case 'a':
        case 'b':
        case 'c':
            return 2;
        case '3':
        case 'd':
        case 'e':
        case 'f':
            return 3;
        case '4':
        case 'g':
        case 'h':
        case 'i':
            return 4;
        case '5':
        case 'j':
        case 'k':
        case 'l':
            return 5;
        case '6':
        case 'm':
        case 'n':
        case 'o':
            return 6;
        case '7':
        case 'p':
        case 'q':
        case 'r':
        case 's':
            return 7;
        case '8':
        case 't':
        case 'u':
        case 'v':
            return 8;
        case '9':
        case 'w':
        case 'x':
        case 'y':
        case 'z':
            return 9;
        case '0':
        case ' ':
            return 0;
        default:
            return -1;
        }
    }

    QSet<QtMobility::QContactLocalId> list;
    T9Trie* children[NUM_CHILDREN];
};

#endif // T9TRIE_H
