#include "qmaemo5homescreenadaptor.h"
#include <QtGui/QApplication>
#include <QtGui/QGraphicsView>
#include <QtGui/QGraphicsScene>
#include <QtGui/QGraphicsProxyWidget>
#include "k9call.h"
#include "contactsthreadworker.h"

int main(int argc, char *argv[])
{
	QApplication a(argc, argv);
	
	// General setup
	qRegisterMetaType<QList <QtMobility::QContact> >("QList<QtMobility::QContact>");
	qRegisterMetaType<QList <QtMobility::QContact> >("QList<QtMobility::QContactLocalId>");
	
    k9call w;
	QGraphicsScene scene;
	QGraphicsProxyWidget *proxy = scene.addWidget(&w);
	QGraphicsView view(&scene);
	QMaemo5HomescreenAdaptor adaptor(&view);

	// Setup the Widget
	proxy->setMaximumSize(400,600);
	proxy->setMinimumSize(400,600);
	view.setFixedSize(600,400);
	view.centerOn(proxy);
	view.setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	view.setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	view.rotate(-90);

	adaptor.setSettingsAvailable(true);
	QObject::connect(&adaptor, SIGNAL(settingsRequested()), &w, SLOT(openSettings()));

	view.show();
	//w.showNormal();

    return a.exec();
}
