/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef SPEEDALARMSETTINGS_H
#define SPEEDALARMSETTINGS_H

#include <QtGui/QDialog>

class QLineEdit;
class QLabel;
class QCheckBox;
class FileSelector;
class SoundSelector;

class SpeedAlarmSettings : public QDialog
{
    Q_OBJECT

public:
    SpeedAlarmSettings(QWidget* parent = 0);

protected:
    virtual void setVisible(bool visible);

private slots:
    void saveSettings();
    void loadCurrentSpeed();

private:
    void loadData();
    QLabel* speedLabel_;
    QLineEdit* speed_;
    SoundSelector* soundSelector_;
    QCheckBox* enabled_;
};

#endif
