/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef IMAGELEMENT_H
#define IMAGELEMENT_H

#include "graphicselement.h"
#include "location.h"

class QString;
class QGraphicsPixmapItem;
class QGraphicsItem;
class Reader;
class GraphicsScene;

class ImageElement : public GraphicsElement
{
public:
    enum Attribute {XPOS, YPOS, ZPOS, VISIBLEWHEN, SRC, WIDTH, HEIGHT, ATTRIBUTE_COUNT};
    ImageElement(Reader* reader);
    virtual bool setAttribute(QString const& name, QString const& value);
    virtual void addToScene(GraphicsScene* scene);
    virtual void update();
    virtual QGraphicsItem* getElement() const;

private:
    bool loadImage(QString const& name);
    QGraphicsPixmapItem* element_;
    QPixmap pixmap_;
    int width_;
    int height_;
    bool imageSet_;
};

#endif
