/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtCore/QString>
#include <QtGui/QHBoxLayout>
#include <QtGui/QPushButton>
#include <QtGui/QDialogButtonBox>
#include "unitselector.h"
#include "buttonselector.h"
#include "settings.h"
#include "buttonbox.h"

UnitSelector::UnitSelector(QWidget* parent): QDialog(parent)
{
    setWindowTitle(tr("Options"));

    unit_ = Settings::instance().value("unit", "km").toString();

    QHBoxLayout* mainLayout = new QHBoxLayout;

    QVBoxLayout* layout = new QVBoxLayout;

    selector_ = new ButtonSelector(tr("Unit"));

    selector_->addItem(tr("Kilometers"), "km");
    selector_->addItem(tr("Miles"), "mile");

    if(unit_ == "mile")
    {
        selector_->setCurrentIndex(1);
    }

    layout->addWidget(selector_);

    orientation_ = Settings::instance().value("orientation", "auto").toString();

    orientationSelector_ = new ButtonSelector(tr("Screen orientation"));

    orientationSelector_->addItem(tr("Automatic"), "auto");
    orientationSelector_->addItem(tr("Landscape"), "landscape");
    orientationSelector_->addItem(tr("Portrait"), "portrait");

    if(orientation_ == "landscape")
    {
        orientationSelector_->setCurrentIndex(1);
    }
    else if(orientation_ == "portrait")
    {
        orientationSelector_->setCurrentIndex(2);
    }

    layout->addWidget(orientationSelector_);

    ButtonBox* buttons = new ButtonBox;
    buttons->setOrientation(Qt::Horizontal);
    connect(buttons->addButton(tr("Save"), QDialogButtonBox::AcceptRole), SIGNAL(clicked(bool)), this, SLOT(saveUnit()));

    mainLayout->addLayout(layout, Qt::AlignLeft);
    mainLayout->addWidget(buttons);

    setLayout(mainLayout);
}

void UnitSelector::saveUnit()
{
    QString unitValue = selector_->value().toString();
    QString orientationValue = orientationSelector_->value().toString();

    if(unitValue != unit_)
    {
        Settings::instance().setValue("unit", unitValue);
        unit_ = unitValue;
        emit unitChanged();
    }

    if(orientationValue != orientation_)
    {
        Settings::instance().setValue("orientation", orientationValue);
        orientation_ = orientationValue;
        emit orientationChanged();
    }

    hide();
}
