/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "orientation.h"

Orientation::Orientation(QMainWindow* window): QtMobility::QOrientationSensor(window),
current_(QtMobility::QOrientationReading::TopUp), orientations_(0), window_(window),
type_(TYPE_AUTO)
{
    connect(this, SIGNAL(readingChanged()), this, SLOT(onReadingChanged()));
}

void Orientation::setSupportedOrientations(int orientations)
{
    orientations_ = orientations;
}

void Orientation::setOrientationType(OrientationType type)
{
    type_ = type;

    handleManualOrientation();
}

void Orientation::update()
{
    if(type_ != TYPE_AUTO)
    {
        handleManualOrientation();
        return;
    }

    using QtMobility::QOrientationReading;

    OrientationName orientation = LANDSCAPE;

    QOrientationReading::Orientation current = reading()->orientation();

    switch(current)
    {
    case QOrientationReading::LeftUp:
        orientation = PORTRAIT;
        break;
    case QOrientationReading::FaceUp:
        if(current_ == QOrientationReading::LeftUp)
        {
            orientation = PORTRAIT;
        }
        else
        {
            orientation = LANDSCAPE;
        }
        break;
    default:
        orientation = LANDSCAPE;
        break;
    }

    current_ = current;

    if(orientations_ & orientation)
    {
        switch(orientation)
        {
        case LANDSCAPE:
            window_->setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
            break;
        case PORTRAIT:
            window_->setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
            break;
        }
    }
    else
    {
        if(orientations_ & LANDSCAPE)
        {
            window_->setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
        }
        else if(orientations_ & PORTRAIT)
        {
            window_->setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
        }
    }
}

void Orientation::onReadingChanged()
{
    if(type_ != TYPE_AUTO)
    {
        return;
    }

    if(reading()->orientation() != current_)
    {
        update();
        emit changed();
    }
}

void Orientation::handleManualOrientation()
{
    switch(type_)
    {
    case TYPE_LANDSCAPE:
        if(orientations_ & LANDSCAPE)
        {
            window_->setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
        }
        else if(orientations_ & PORTRAIT)
        {
            window_->setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
        }
        break;
    case TYPE_PORTRAIT:
        if(orientations_ & PORTRAIT)
        {
            window_->setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
        }
        else if(orientations_ & LANDSCAPE)
        {
            window_->setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
        }
        break;
    default:
        break;
    }
}
