/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef FILESELECTOR_H
#define FILESELECTOR_H

#include "buttonselector.h"

class QString;

class FileSelector : public ButtonSelector
{
    Q_OBJECT

public:
    FileSelector(QString const& text, QWidget* parent = 0);
    bool loadFiles(QString const& dir, QStringList const& patterns, bool stripType = false);
    bool loadFiles(QString const& dir, QString const& pattern, bool stripType = false);
    bool importFile(QString const& dir, QString const& name,
                    QString const& pattern, bool add = true,
                    QString* addedFile = 0);

private:
    bool confirmCopy(QString const& filename);

};

#endif
