/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtCore/QString>
#include <QtCore/QDebug>
#include <QtGui/QGraphicsSceneMouseEvent>
#include "toolbaritem.h"

ToolbarItem::ToolbarItem(QString const& filename, QString const& activeFilename, QGraphicsItem *parent):
QGraphicsPixmapItem(parent), active_(false)
{
    pixmap_.load(filename);
    activePixmap_.load(activeFilename);
    setPixmap(pixmap_);
}

void ToolbarItem::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    Q_UNUSED(event);
    setPixmap(activePixmap_);
    active_ = true;
}

void ToolbarItem::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
{
    Q_UNUSED(event);

    if(active_)
    {
        active_ = false;
        setPixmap(pixmap_);
        update();
        emit clicked();
    }
}

void ToolbarItem::mouseMoveEvent(QGraphicsSceneMouseEvent* event)
{
    QPointF pos = event->pos();
    qreal x = pos.x();
    qreal y = pos.y();

    if(active_ && (x < 0 || y < 0 || x > activePixmap_.width() || y > activePixmap_.height()))
    {
        active_ = false;
        setPixmap(pixmap_);
    }
}

