/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef ORIENTATION_H
#define ORIENTATION_H

#include <QtGui/QMainWindow>
#include <QOrientationReading>
#include <QOrientationSensor>

class Orientation : public QtMobility::QOrientationSensor
{
    Q_OBJECT

public:
    enum OrientationName {LANDSCAPE = 0x01, PORTRAIT = 0x02};
    enum OrientationType {TYPE_AUTO, TYPE_LANDSCAPE, TYPE_PORTRAIT};
    Orientation(QMainWindow* window);
    void setSupportedOrientations(int orientations);
    void setOrientationType(OrientationType type);

public slots:
    void update();

signals:
    void changed();

private slots:
    void onReadingChanged();
    void handleManualOrientation();

private:
    QtMobility::QOrientationReading::Orientation current_;
    int orientations_;
    QMainWindow* window_;
    OrientationType type_;
};

#endif
