/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtCore/QString>
#include <QtCore/QDebug>
#include <QtGui/QGraphicsOpacityEffect>
#include <QtGui/QGraphicsItem>
#include "opacityeffect.h"
#include "graphicselement.h"

namespace
{
    Effect::AttributeDetails ATTRIBUTES[OpacityEffect::ATTRIBUTE_COUNT] =
    {
     {"opacity", true}
    };
}

OpacityEffect::OpacityEffect(): Effect()
{
    effect_ = new QGraphicsOpacityEffect;
}

bool OpacityEffect::setAttribute(QString const& name, QString const& value)
{
    qreal realVal = 0;
    int attrId = -1;

    if((attrId = getAttribute(name, value, ATTRIBUTES, ATTRIBUTE_COUNT, realVal)) != -1)
    {
        Attribute attr = static_cast<Attribute>(attrId);

        switch(attr)
        {
        case OPACITY:
            effect_->setOpacity(realVal);
            break;
        default:
            qDebug() << "Unknown attribute: " << attr;
            return false;
        }

        return true;
    }
    else
    {
        return false;
    }
}

void OpacityEffect::apply(GraphicsElement* item)
{
    item->getElement()->setGraphicsEffect(effect_);
}
