/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtCore/QString>
#include <QtGui/QHBoxLayout>
#include <QtGui/QPushButton>
#include <QtGui/QDialogButtonBox>
#include "unitselector.h"
#include "buttonselector.h"
#include "settings.h"
#include "buttonbox.h"

UnitSelector::UnitSelector(QWidget* parent): QDialog(parent)
{
    setWindowTitle(tr("Set unit"));

    unit_ = Settings::instance().value("unit", "km").toString();

    QHBoxLayout* layout = new QHBoxLayout;

    selector_ = new ButtonSelector(tr("Unit"));

    selector_->addItem(tr("Kilometers"), "km");
    selector_->addItem(tr("Miles"), "mile");

    if(unit_ == "mile")
    {
        selector_->setCurrentIndex(1);
    }

    layout->addWidget(selector_, Qt::AlignLeft);

    ButtonBox* buttons = new ButtonBox;
    buttons->setOrientation(Qt::Horizontal);
    connect(buttons->addButton(tr("Save"), QDialogButtonBox::AcceptRole), SIGNAL(clicked(bool)), this, SLOT(saveUnit()));

    layout->addWidget(buttons);

    setLayout(layout);
}

void UnitSelector::saveUnit()
{
    QString value = selector_->value().toString();

    if(value == unit_)
    {
        hide();
        return;
    }

    Settings::instance().setValue("unit", value);
    unit_ = value;
    hide();
    emit unitChanged();
}
