/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef THEMESELECTOR_H
#define THEMESELECTOR_H

#include <QtGui/QDialog>

class QString;
class ThemePicker;
class ThemeSchedulerSettings;

class ThemeSelector : public QDialog
{
    Q_OBJECT

public:
    ThemeSelector(QWidget* parent = 0);

signals:
    void themeChanged();

protected:
    virtual void setVisible(bool visible);

private slots:
    void saveTheme();
    void loadFromFile();
    void openScheduler();
    void setButtonClicked();
    void setThemeSelected();
    void onThemeChanged();

private:
    bool buttonClicked_;
    bool themeSelected_;
    ThemePicker* selector_;
    ThemeSchedulerSettings* themeScheduler_;
};


#endif
