/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef READER_H
#define READER_H

class QString;
class QByteArray;

class Reader
{
public:
    Reader();
    virtual bool open() = 0;
    virtual bool readFile(QString const& filename, QByteArray& data) = 0;
    virtual bool fileExists(QString const& filename) const = 0;
    virtual bool close() = 0;
    virtual QString const& errorString() const = 0;
};

#endif
