/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef POIALERTS_H
#define POIALERTS_H

#include <QtCore/QList>
#include <QtCore/QSet>
#include <QtCore/QQueue>
#include "poireader.h"

class QString;

class PoiAlerts : public QObject
{
    Q_OBJECT

public:
    static int const POI_ALERT_INTERVAL = 120;
    static int const IN_ROUTE_MARGIN = 20;
    static PoiAlerts& instance();
    static QString getPoiDir();
    ~PoiAlerts();
    bool start();
    void end();
    double getCurrentDistance() const;
    QString getCurrentPoi() const;
    bool poiInView() const;
    QString const& error() const;

signals:
    void visibilityChanged(bool visible);

public slots:
    bool loadConfig();

private slots:
    void onDataUpdated();
    void removePlayed();

private:
    PoiAlerts();
    bool loadPois();
    void playSound(int poiIndex);
    static double calculateDistance(double latitude1, double longitude1,
                                    double latitude2, double longitude2);
    static double calculateTrack(double latitude1, double longitude1,
                                 double latitude2, double longitude2);
    QString file_;
    bool onlyOnRoute_;
    QList<PoiReader::Poi> pois_;
    QQueue<int> playedSounds_;
    bool enabled_;
    double distance_;
    double travelled_;
    PoiReader::Poi* currentPoi_;
    double currentDistance_;
    bool loaded_;
    QString error_;

};

#endif
