/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtCore/QFile>
#include <QtGui/QHBoxLayout>
#include "soundselector.h"
#include "fileselector.h"
#include "mediaplayer.h"

SoundSelector::SoundSelector(QWidget* parent): QHBoxLayout(parent)
{
    selector_ = new FileSelector(tr("Sound"));
    QPushButton* playButton = new QPushButton(tr("Play"));
    connect(playButton, SIGNAL(clicked(bool)), this, SLOT(playSound()));
    addWidget(selector_, Qt::AlignLeft);
    addWidget(playButton);
}

void SoundSelector::playSound()
{
    QString sound = selector_->value().toString();

    if(sound.isEmpty())
    {
        return;
    }

    QString soundDir = MediaPlayer::getSoundDir();
    QString localDir = MediaPlayer::getLocalSoundDir();

    if(QFile::exists(soundDir + sound))
    {
        MediaPlayer::play(soundDir + sound);
    }
    else if(QFile::exists(localDir + sound))
    {
        MediaPlayer::play(localDir + sound);
    }
}

void SoundSelector::load()
{
    QString currentValue = selector_->value().toString();
    selector_->clear();
    QStringList patterns = MediaPlayer::getFormatPatterns();
    selector_->loadFiles(MediaPlayer::getLocalSoundDir(), patterns);
    selector_->loadFiles(MediaPlayer::getSoundDir(), patterns);
    setValue(currentValue);
}

void SoundSelector::setValue(QString const& value)
{
    selector_->selectByValue(value);
}

QString SoundSelector::value() const
{
    return selector_->value().toString();
}
