/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtCore/QString>
#include <QtCore/QDebug>
#include <QtCore/QTimer>
#include <QtGui/QGraphicsItem>
#include <math.h>
#include "flickereffect.h"
#include "graphicselement.h"

namespace
{
    Effect::AttributeDetails ATTRIBUTES[FlickerEffect::ATTRIBUTE_COUNT] =
    {
     {"interval", true}
    };
}

FlickerEffect::FlickerEffect(): QObject(0), Effect(), interval_(500), timer_(0), item_(0)
{
}

FlickerEffect::~FlickerEffect()
{
    delete timer_;
}

bool FlickerEffect::setAttribute(QString const& name, QString const& value)
{
    qreal realVal = 0;
    int attrId = -1;

    if((attrId = getAttribute(name, value, ATTRIBUTES, ATTRIBUTE_COUNT, realVal)) != -1)
    {
        Attribute attr = static_cast<Attribute>(attrId);

        switch(attr)
        {
        case INTERVAL:
            interval_ = round(realVal);
            break;
        default:
            qDebug() << "Unknown attribute: " << attr;
            return false;
        }

        return true;
    }
    else
    {
        return false;
    }
}

void FlickerEffect::apply(GraphicsElement* item)
{
    if(interval_ > 0)
    {
        item_ = item;
        timer_ = new QTimer;
        timer_->setInterval(interval_);
        connect(timer_, SIGNAL(timeout()), this, SLOT(updateVisibility()));
        timer_->start();
    }
}

void FlickerEffect::updateVisibility()
{
    if(item_ && item_->canBeVisible())
    {
        item_->getElement()->setVisible(!item_->getElement()->isVisible());
    }
}
