/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>

class MainWindowStack;
class MainMenu;
class ThemeLoader;
class WidgetScreen;

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow();
    ~MainWindow();

signals:
    void quit();

private slots:
    void loadServices();
    void minimize();
    void openMenu();
    void keepBacklightOn();
    bool loadTheme();

private:
    void addScreens();
    void startGps();
    void startBacklight();
    MainWindowStack* stack_;
    MainMenu* menu_;
    ThemeLoader* themeLoader_;
    WidgetScreen* mainScreen_;

};

#endif
