/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef THEMELOADER_H
#define THEMELOADER_H

#include <QtCore/QObject>

class QString;
class QDomDocument;
class Reader;
class WidgetScreen;

class ThemeLoader : public QObject
{
public:
    ThemeLoader(WidgetScreen* mainScreen, WidgetScreen* detailScreen, QObject* parent = 0);
    ~ThemeLoader();
    bool load();
    QString const& error() const;
    static QString getThemeDir();
    static QString const& getThemeSuffix();

private:
    bool read();
    bool loadScreen(QString const& tag, QDomDocument const& doc, WidgetScreen* screen);
    Reader* reader_;
    QString error_;
    WidgetScreen* mainScreen_;
    WidgetScreen* detailScreen_;

};

#endif
