/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef DETAILSCREEN_H
#define DETAILSCREEN_H

#include "themescreen.h"

class QString;
class QGraphicsTextItem;
class QGraphicsLineItem;
class QGraphicsPixmapItem;

class DetailScreen : public ThemeScreen
{
    Q_OBJECT

public:
    DetailScreen(QWidget* parent = 0);
    virtual void setColor(QString const& color);

public slots:
    virtual void update();
    void reArrange();

private slots:
    void updateTime();
    void updateUnits();

private:
    QString formatTime(qulonglong time);
    QGraphicsTextItem* createItem(QString const& text);
    QGraphicsLineItem* createLine();
    QString roundDouble(double number);
    int getStrength();
    QGraphicsTextItem* tripLabel_;
    QGraphicsTextItem* trip_;
    QGraphicsTextItem* tripUnit_;
    QGraphicsTextItem* totalLabel_;
    QGraphicsTextItem* total_;
    QGraphicsTextItem* totalUnit_;
    QGraphicsTextItem* speedLabel_;
    QGraphicsTextItem* speed_;
    QGraphicsTextItem* speedUnit_;
    QGraphicsTextItem* avgSpeedLabel_;
    QGraphicsTextItem* avgSpeed_;
    QGraphicsTextItem* avgSpeedUnit_;
    QGraphicsTextItem* maxSpeedLabel_;
    QGraphicsTextItem* maxSpeed_;
    QGraphicsTextItem* maxSpeedUnit_;
    QGraphicsTextItem* tripTimeLabel_;
    QGraphicsTextItem* tripTime_;
    QGraphicsTextItem* totalTimeLabel_;
    QGraphicsTextItem* totalTime_;
    QGraphicsLineItem* line1_;
    QGraphicsLineItem* line2_;
    QGraphicsPixmapItem* strength_;
    int currentStrength_;
};

#endif
