QT += maemo5 xml
TARGET = jspeed
TEMPLATE = app
SOURCES += src/main.cpp \ 
           src/mainwindow.cpp \
           src/mainwindowstack.cpp \
           src/location.cpp \
           src/graphicsscreen.cpp \
           src/abstractscreen.cpp \
           src/widgetscreen.cpp \
           src/toolbaritem.cpp \
           src/reader.cpp \
           src/zipreader.cpp \
           src/filereader.cpp \
           src/graphicselement.cpp \
           src/textelement.cpp \
           src/imageelement.cpp \
           src/rectangle.cpp \
           src/pointer.cpp \
           src/odometer.cpp \
           src/themeloader.cpp \
           src/themescreen.cpp \
           src/settings.cpp \
           src/detailscreen.cpp \
           src/graphicsscene.cpp \
           src/mainmenu.cpp \
           src/buttonselector.cpp \
           src/themeselector.cpp \
           src/unitselector.cpp \
           src/effect.cpp \
           src/blureffect.cpp \
           src/opacityeffect.cpp \
           src/dropshadoweffect.cpp
HEADERS += src/mainwindow.h \
           src/mainwindowstack.h \
           src/location.h \
           src/graphicsscreen.h \
           src/abstractscreen.h \
           src/widgetscreen.h \
           src/toolbaritem.h \
           src/reader.h \
           src/zipreader.h \
           src/filereader.h \
           src/graphicselement.h \
           src/textelement.h \
           src/imageelement.h \
           src/rectangle.h \
           src/pointer.h \
           src/odometer.h \
           src/themeloader.h \
           src/themescreen.h \
           src/settings.h \
           src/detailscreen.h \
           src/graphicsscene.h \
           src/mainmenu.h \
           src/buttonselector.h \
           src/themeselector.h \
           src/unitselector.h \
           src/effect.h \
           src/blureffect.h \
           src/opacityeffect.h \
           src/dropshadoweffect.h
RESOURCES = src/resources.qrc
CONFIG += link_pkgconfig
PKGCONFIG += liblocation libzip

unix {
  #VARIABLES
  isEmpty(PREFIX) {
    PREFIX = /usr
  }

  BINDIR = $$PREFIX/bin
  DATADIR =$$PREFIX/share
  THEMEDIR = /home/user/.jspeed/themes

  DEFINES += DATADIR=\\\"$$DATADIR\\\" PKGDATADIR=\\\"$$PKGDATADIR\\\"

  #MAKE INSTALL

  INSTALLS += target desktop themes icon26 icon48 icon64

  target.path =$$BINDIR

  desktop.path = $$DATADIR/applications/hildon
  desktop.files += src/data/$${TARGET}.desktop

  themes.path = $$THEMEDIR
  themes.files += src/data/themes/graphical.jspeed \
                  src/data/themes/white.jspeed \
                  src/data/themes/dark.jspeed

  icon26.path = $$DATADIR/icons/hicolor/26x26/apps
  icon26.files += src/data/26x26/$${TARGET}.png

  icon48.path = $$DATADIR/icons/hicolor/48x48/apps
  icon48.files += src/data/48x48/$${TARGET}.png

  icon64.path = $$DATADIR/icons/hicolor/64x64/apps
  icon64.files += src/data/64x64/$${TARGET}.png
}
