/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtGui/QGraphicsSceneMouseEvent>
#include "graphicsscene.h"

GraphicsScene::GraphicsScene(QRectF const& rect): QGraphicsScene(rect)
{
}

void GraphicsScene::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    QGraphicsScene::mousePressEvent(event);

    QPointF pos = event->screenPos();

    if(pos.x() > CLICK_MARGIN && pos.x() < (width() - CLICK_MARGIN) &&
       pos.y() > CLICK_MARGIN && pos.y() < (height() - CLICK_MARGIN))
    {
        emit clicked();
    }
}
