/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtCore/QDebug>
#include <QtGui/QVBoxLayout>
#include <QtGui/QHBoxLayout>
#include <QtGui/QLabel>
#include "eniroguiconfig.h"
#include "eniro.h"

EniroGuiConfig::EniroGuiConfig(QWidget* parent):
SourceGuiConfig(parent), EniroCoreConfig(), layout_(0), usernameInput_(0),
passwordInput_(0), siteSelector_(0), usernameLabel_(0), passwordLabel_(0)
{
    load();
    loadLayout(getSite());
}

EniroGuiConfig::~EniroGuiConfig()
{
}

void EniroGuiConfig::save()
{
    if(usernameInput_ && passwordInput_)
    {
        setUsername(usernameInput_->text());
        setPassword(passwordInput_->text());
    }

    setSite(siteSelector_->value().toString());

    store();
}

void EniroGuiConfig::loadLayout(QString const& site)
{
    if(layout())
    {
        siteSelector_->hide();
        siteSelector_ = 0;

        if(usernameLabel_ && passwordLabel_)
        {
            usernameLabel_->hide();
            usernameLabel_ = 0;
            usernameInput_->hide();
            usernameInput_ = 0;
            passwordLabel_->hide();
            passwordLabel_ = 0;
            passwordInput_->hide();
            passwordInput_ = 0;
        }

        delete layout();
        layout_ = 0;

    }

    layout_ = new QVBoxLayout;

    QMap <Eniro::Site, Eniro::SiteDetails> sites = Eniro::getSites();

    siteSelector_ = new ButtonSelector(tr("Eniro site"), this);
    int i = 0;

    QMap <Eniro::Site, Eniro::SiteDetails>::const_iterator it;
    for(it = sites.begin(); it != sites.end(); it++)
    {
        QString name;

        switch(it.key())
        {
        case Eniro::FI:
            name = tr("Finnish");
            break;
        case Eniro::SE:
            name = tr("Swedish");
            break;
        case Eniro::DK:
            name = tr("Danish");
            break;
        default:
            qDebug() << "Unknown site";
            continue;

        }
        siteSelector_->addItem(name, it.value().id);

        if(it.value().id == site)
        {
            siteSelector_->setCurrentIndex(i);
        }

        i++;
    }

    connect(siteSelector_, SIGNAL(selected(unsigned int, QString const&, QVariant const&)),
            this, SLOT(siteChanged(unsigned int, QString const&, QVariant const&)));

    layout_->addWidget(siteSelector_);

    if(site == "fi")
    {
        QHBoxLayout* username = new QHBoxLayout;
        QHBoxLayout* password = new QHBoxLayout;

        usernameLabel_ = new QLabel(tr("Eniro username"));
        usernameInput_ = new QLineEdit(getUsername());

        passwordLabel_ = new QLabel(tr("Eniro password"));
        passwordInput_ = new QLineEdit(getPassword());
        passwordInput_->setEchoMode(QLineEdit::PasswordEchoOnEdit);

        username->addWidget(usernameLabel_);
        username->addWidget(usernameInput_);
        password->addWidget(passwordLabel_);
        password->addWidget(passwordInput_);

        layout_->addLayout(username);
        layout_->addLayout(password);
    }

    setLayout(layout_);
}

void EniroGuiConfig::siteChanged(unsigned int index,
                                 QString const& text,
                                 QVariant const& value)
{
    Q_UNUSED(index);
    Q_UNUSED(text);
    loadLayout(value.toString());
}
