/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef CONNECTIONMANAGER_H
#define CONNECTIONMANAGER_H

#include <QtCore/QObject>
#include <QtCore/QTimerEvent>
#include <QtCore/QString>
#include <QtCore/QByteArray>
#include <QtCore/QList>
#include <QtDBus/QDBusInterface>
#include <QtDBus/QDBusMessage>

class ConnectionManager : public QObject
{
    Q_OBJECT

public:

    enum ConnectionType {NO_TYPE, WLAN, GPRS};
    enum Error {NO_ERROR, NO_AVAILABLE_CONNECTIONS, INVALID_IAP, UNKNOWN_ERROR};

    struct Connection
    {
        ConnectionType type;
        QString id;
        QString name;
        int strength;
    };

    ConnectionManager(QObject* parent = 0);
    ~ConnectionManager();
    bool connect();
    bool connect(Connection const& connection);
    bool connect(QString const& id);
    bool getBestConnection(Connection& connection, ConnectionType type = NO_TYPE);
    bool disconnect(bool force = false);
    bool isConnected();
    bool scanConnections(QList<Connection>& connections, ConnectionType type = NO_TYPE);
    Error error() const;
    static unsigned int const TIMEOUT = 15000;

protected:
    virtual void timerEvent(QTimerEvent* event);

private slots:
    void stateChange(const QDBusMessage& rep);
    void connectionChange(const QDBusMessage& rep);
    void scanResult(const QDBusMessage& rep);

private:
    bool waitSignal(bool* ready);
    bool stateReady_;
    bool connectionReady_;
    bool scanReady_;
    static bool connected_;
    bool timeout_;
    int numberOfConnections_;
    int scannedConnections_;
    int timer_;
    ConnectionType searchType_;
    Error error_;
    QList<Connection>* connections_;
    QDBusInterface* icd2interface_;
};

#endif
