/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtCore/QString>
#include <QtGui/QMainWindow>
#include <QtGui/QToolButton>
#include <QtGui/QListWidget>
#include "searchdialog.h"
#include "settingsdialog.h"
#include "aboutdialog.h"
#include "source.h"
#include "logwindow.h"

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget* parent = 0);
    ~MainWindow();

signals:
    void search(SearchDialog::SearchDetails& details);
    void logItemSelected(Source::Result const& result);

public slots:
    void showSettings();
    void showAbout();
    void toggleDaemon();
    void openSearch();
    void openLog();
    void handleSearch(SearchDialog::SearchDetails& details);

private:
    QToolButton* createButton(QString const& text);
    QListWidget* searchResults_;
    SettingsDialog* settingsDialog_;
    bool running_;
    QToolButton* toggleButton_;
    SearchDialog* searchDialog_;
    AboutDialog* aboutDialog_;
    QDialog* warning_;
    LogWindow* logWindow_;

};

#endif
